# Composition: Laboratory Order (CZ) - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Composition: Laboratory Order (CZ)**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-CompositionLabOrder-definitions.md) 
*  [Mappings](StructureDefinition-cz-CompositionLabOrder-mappings.md) 
*  [XML](StructureDefinition-cz-CompositionLabOrder.profile.xml.md) 
*  [JSON](StructureDefinition-cz-CompositionLabOrder.profile.json.md) 
*  [TTL](StructureDefinition-cz-CompositionLabOrder.profile.ttl.md) 

## Resource Profile: Composition: Laboratory Order (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-order/StructureDefinition/cz-CompositionLabOrder | *Version*:0.0.1 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_CompositionLabOrder |
| **Copyright/Legal**: HL7 CZ | | |

 
Clinical document used to represent a Laboratory Order for the scope of this guide. 

 
Laboratory order bundle is an electronic health record extract containing order of laboratory examination for subject of care, comprising at least the required elements of the lab dataset. 

**Usages:**

* Use this Profile: [Bundle: Laboratory Order (CZ)](StructureDefinition-BundleLabOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab-order|current/StructureDefinition/cz-CompositionLabOrder)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Composition](http://hl7.org/fhir/R4/composition.html) 

#### Terminology Bindings (Differential)

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [Composition](http://hl7.org/fhir/R4/composition.html) 

**Summary**

Mandatory: 6 elements(4 nested mandatory elements)
 Must-Support: 1 element

**Structures**

This structure refers to these other structures:

* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Device: Performer/Observer (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-device-observer)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-device-observer.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Related Person (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-relatedPerson-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)
* [Patient: Animal (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-animal)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-animal.html)
* [Location (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-location-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-location-core.html)
* [Medical Device (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-medical-device.html)
* [Encounter: Lab Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-encounter)](StructureDefinition-cz-encounter.md)
* [ServiceRequest: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-serviceRequest)](StructureDefinition-cz-serviceRequest.md)
* [Clinical question: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-clinicalQuestion)](StructureDefinition-cz-clinicalQuestion.md)
* [Coverage (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-coverage)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)
* [Appointment (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-appointment)](StructureDefinition-cz-appointment.md)
* [Medication Statement (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-MedicationStatement.html)
* [Attachment Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-attachment)](StructureDefinition-cz-attachment.md)

**Extensions**

This structure refers to these extensions:

* [http://hl7.eu/fhir/StructureDefinition/presentedForm](http://hl7.eu/fhir/extensions/0.1.1-ballot/StructureDefinition-presentedForm.html)
* [http://hl7.eu/fhir/StructureDefinition/information-recipient|0.1.1-ci-build](https://build.fhir.org/ig/hl7-eu/extensions/StructureDefinition-information-recipient.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Composition.section

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Composition](http://hl7.org/fhir/R4/composition.html) 

#### Terminology Bindings (Differential)

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Composition](http://hl7.org/fhir/R4/composition.html) 

**Summary**

Mandatory: 6 elements(4 nested mandatory elements)
 Must-Support: 1 element

**Structures**

This structure refers to these other structures:

* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Device: Performer/Observer (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-device-observer)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-device-observer.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Related Person (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-relatedPerson-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)
* [Patient: Animal (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-animal)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-animal.html)
* [Location (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-location-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-location-core.html)
* [Medical Device (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-medical-device.html)
* [Encounter: Lab Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-encounter)](StructureDefinition-cz-encounter.md)
* [ServiceRequest: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-serviceRequest)](StructureDefinition-cz-serviceRequest.md)
* [Clinical question: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-clinicalQuestion)](StructureDefinition-cz-clinicalQuestion.md)
* [Coverage (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-coverage)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)
* [Appointment (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-appointment)](StructureDefinition-cz-appointment.md)
* [Medication Statement (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-MedicationStatement.html)
* [Attachment Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-attachment)](StructureDefinition-cz-attachment.md)

**Extensions**

This structure refers to these extensions:

* [http://hl7.eu/fhir/StructureDefinition/presentedForm](http://hl7.eu/fhir/extensions/0.1.1-ballot/StructureDefinition-presentedForm.html)
* [http://hl7.eu/fhir/StructureDefinition/information-recipient|0.1.1-ci-build](https://build.fhir.org/ig/hl7-eu/extensions/StructureDefinition-information-recipient.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Composition.section

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 

Other representations of profile: [CSV](StructureDefinition-cz-CompositionLabOrder.csv), [Excel](StructureDefinition-cz-CompositionLabOrder.xlsx), [Schematron](StructureDefinition-cz-CompositionLabOrder.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

