# Bundle: Laboratory Order (CZ) - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle: Laboratory Order (CZ)**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-BundleLabOrderCz-definitions.md) 
*  [Mappings](StructureDefinition-BundleLabOrderCz-mappings.md) 
*  [Examples](StructureDefinition-BundleLabOrderCz-examples.md) 
*  [XML](StructureDefinition-BundleLabOrderCz.profile.xml.md) 
*  [JSON](StructureDefinition-BundleLabOrderCz.profile.json.md) 
*  [TTL](StructureDefinition-BundleLabOrderCz.profile.ttl.md) 

## Resource Profile: Bundle: Laboratory Order (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-order/StructureDefinition/BundleLabOrderCz | *Version*:0.0.1 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:BundleLabOrderCz |
| **Copyright/Legal**: HL7 CZ | | |

 
Clinical document used to represent a Laboratory Order for the scope of this guide. 

 
Laboratory order bundle is an electronic health record extract containing order of laboratory examination for subject of care, comprising at least the required elements of the lab dataset. 

**Usages:**

* Examples for this Profile: [Bundle/CZ-LabOrder-Bundle-Example](Bundle-CZ-LabOrder-Bundle-Example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab-order|current/StructureDefinition/BundleLabOrderCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

**Summary**

Mandatory: 6 elements(1 nested mandatory element)
 Prohibited: 6 elements

**Structures**

This structure refers to these other structures:

* [Composition: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-CompositionLabOrder)](StructureDefinition-cz-CompositionLabOrder.md)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Patient: Animal (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-animal)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-animal.html)
* [ServiceRequest: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-serviceRequest)](StructureDefinition-cz-serviceRequest.md)
* [Clinical question: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-clinicalQuestion)](StructureDefinition-cz-clinicalQuestion.md)
* [Appointment (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-appointment)](StructureDefinition-cz-appointment.md)
* [Specimen (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-specimen)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-specimen.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Coverage (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-coverage)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)
* [Medication Statement (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-MedicationStatement.html)
* [Condition: Lab Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-conditionLab)](StructureDefinition-cz-conditionLab.md)
* [Allergy Intolerance (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-allergyIntolerance.html)
* [Observation: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-observation)](StructureDefinition-cz-observation.md)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)
* [Attachment Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-attachment)](StructureDefinition-cz-attachment.md)
* [Signature (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-signature)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-signature.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 2 is sliced based on the values of Bundle.entry

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

**Summary**

Mandatory: 6 elements(1 nested mandatory element)
 Prohibited: 6 elements

**Structures**

This structure refers to these other structures:

* [Composition: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-CompositionLabOrder)](StructureDefinition-cz-CompositionLabOrder.md)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Patient: Animal (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-animal)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-animal.html)
* [ServiceRequest: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-serviceRequest)](StructureDefinition-cz-serviceRequest.md)
* [Clinical question: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-clinicalQuestion)](StructureDefinition-cz-clinicalQuestion.md)
* [Appointment (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-appointment)](StructureDefinition-cz-appointment.md)
* [Specimen (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-specimen)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-specimen.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Coverage (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-coverage)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)
* [Medication Statement (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-MedicationStatement.html)
* [Condition: Lab Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-conditionLab)](StructureDefinition-cz-conditionLab.md)
* [Allergy Intolerance (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-allergyIntolerance.html)
* [Observation: Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-observation)](StructureDefinition-cz-observation.md)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)
* [Attachment Laboratory Order (CZ)(https://hl7.cz/fhir/lab-order/StructureDefinition/cz-attachment)](StructureDefinition-cz-attachment.md)
* [Signature (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-signature)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-signature.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 2 is sliced based on the values of Bundle.entry

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 

Other representations of profile: [CSV](StructureDefinition-BundleLabOrderCz.csv), [Excel](StructureDefinition-BundleLabOrderCz.xlsx), [Schematron](StructureDefinition-BundleLabOrderCz.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

