# CZ Header Model to this guide Map - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CZ Header Model to this guide Map**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-LabOrderHeader2FHIRcz-cz.xml.md) 
*  [JSON](ConceptMap-LabOrderHeader2FHIRcz-cz.json.md) 
*  [TTL](ConceptMap-LabOrderHeader2FHIRcz-cz.ttl.md) 

## ConceptMap: CZ Header Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-order/ConceptMap/LabOrderHeader2FHIRcz-cz | *Version*:0.0.1 |
| Draft as of 2025-10-08 | *Computable Name*:LabOrderHeader2FHIRcz |

 
CZ Laboratory Order Header Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md) to [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

* **Source Code**: Subject.identification (A.1.1 Identification of the patient/subject)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient
* **Source Code**: Subject.identification.givenName (A.1.1.1 Given name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.name.given
* **Source Code**: Subject.identification.familyName (A.1.1.2 Familyname/surname)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.name.family
* **Source Code**: Subject.identification.dateOfBirth (A.1.1.3 Date of birth)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.birthDate
* **Source Code**: Subject.identification.dateOfDeath (A.1.1.4 Date of death)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.deceased[x].deceasedDateTime
* **Source Code**: Subject.identification.identifier (A.1.1.5 Patient identifier)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.identifier
* **Source Code**: Subject.identification.citizenship (A.1.1.6 Citizenship)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.patient-citizenship
* **Source Code**: Subject.identification.gender (A.1.1.7 Gender)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.gender
* **Source Code**: Subject.identification.genderForClinicalUse (A.1.1.8 Gender)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.extension:sex-for-clinical-use
* **Source Code**: Subject.identification.languageOfCommunication (A.1.1.9 Language of communication)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.communication.language
* **Source Code**: Subject.identification.handicap (A.1.1.10 Handicap)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.text
* **Source Code**: Subject.contactInfo (A.1.2 Patient/subject related contact information)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient
* **Source Code**: Subject.contactInfo.address (A.1.2.1 Address)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.address
* **Source Code**: Subject.contactInfo.telecom (A.1.2.2 Telecom)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.telecom
* **Source Code**: Subject.contactInfo.preferedPhysician (A.1.2.3 Prefered physician)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.generalPractitioner
* **Source Code**: Subject.contactInfo.legalRepresent (A.1.2.4 Legal representatives and other contact persons)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact
* **Source Code**: Subject.contactInfo.legalRepresent.type (A.1.2.4.1 Contact type)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient.contact.relationship
* **Source Code**: Subject.contactInfo.legalRepresent.relationToSubject (A.1.2.4.2 Relationship to the patient)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact.relationship
* **Source Code**: Subject.contactInfo.legalRepresent.identifier (A.1.2.4.3 Person identifier)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient.contact
* **Source Code**: Subject.contactInfo.legalRepresent.givenName (A.1.2.4.4 Given name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact.name.given
* **Source Code**: Subject.contactInfo.legalRepresent.familyName (A.1.2.4.5 Family name/surname)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact.name.family
* **Source Code**: Subject.contactInfo.legalRepresent.address (A.1.2.4.6 Contact person address)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact.address
* **Source Code**: Subject.contactInfo.legalRepresent.telecom (A.1.2.4.7 Telecom)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact.telecom

-------

**Group 2**Mapping from [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md) to [Practitioner (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)

* **Source Code**: Subject.contactInfo.preferedPhysician (A.1.2.3 Prefered physician)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practitioner
* **Source Code**: Subject.contactInfo.preferedPhysician.Identifier (A.1.2.3.1 Identification of the prefered physician)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practitioner.identifier
* **Source Code**: Subject.contactInfo.preferedPhysician.Name (A.1.2.3.2 Name of the prefered physician)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practitioner.name
* **Source Code**: Subject.contactInfo.preferedPhysician.telecom (A.1.2.3.6 Telecom)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practitioner.telecom

-------

**Group 3**Mapping from [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md) to [Practitioner Role (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)

* **Source Code**: Subject.contactInfo.preferedPhysician (A.1.2.3 Prefered physician)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole
* **Source Code**: Subject.contactInfo.preferedPhysician.Identifier (A.1.2.3.1 Identification of the prefered physician)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.identifier
* **Source Code**: Subject.contactInfo.preferedPhysician.Name (A.1.2.3.2 Name of the prefered physician)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.practiotioner.name
* **Source Code**: Subject.contactInfo.preferedPhysician.Specialization (A.1.2.3.3 Specialization of the prefered physician)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.speciality
* **Source Code**: Subject.contactInfo.preferedPhysician.providerIdentifierName (A.1.2.3.4 Identification and name of the provider the doctor represents)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.organization.name
* **Source Code**: Subject.contactInfo.preferedPhysician.providerAddress (A.1.2.3.5 Provider address)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.organization.address
* **Source Code**: Subject.contactInfo.preferedPhysician.telecom (A.1.2.3.6 Telecom)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.telecom

-------

**Group 4**Mapping from [A.1.3 - Health insurance and payment information](StructureDefinition-PayerCz.md) to [Coverage (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)

* **Source Code**: Header.payer (A.1.3 - Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:order.insurance
  * **Comment**: Composition.section:order.entry.ofType(CZ_ImagingInformationAboutOrder).insurance.ofType(CZ_Coverage)
* **Source Code**: Header.payer.insuranceCode (A.1.3.1 - Health insurance code)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Coverage.payor.identifier
  * **Comment**: 
* **Source Code**: Header.payer.insuranceName (A.1.3.2 - Health insurance name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Coverage.payor.name
  * **Comment**: 
* **Source Code**: Header.payer.insuranceNumber (A.1.3.3 - Health insurance number)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Coverage.identifier
  * **Comment**: 

-------

**Group 5**Mapping from [A.1.4 - Information about coverage](StructureDefinition-CoverageOrderCz.md) to [Coverage (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)

* **Source Code**: Header.coverage (A.1.4 - Information about coverage)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:Coverage
  * **Comment**: Composition.section:Coverage.entry.ofType(CZ_Coverage)
* **Source Code**: Header.coverage.method (A.1.4.1 - Coverage method)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Coverage.type
  * **Comment**: 
* **Source Code**: Header.coverage.informationPayor (A.1.4.2 - Information about Payor)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Coverage.payor
  * **Comment**: 

-------

**Group 6**Mapping from [A.1.5 - Author](StructureDefinition-AuthorCz.md) to `https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerRole-core`

* **Source Code**: Header.author (A.1.5 - Author (by whom the Imaging Order was/were authored))
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.author
  * **Comment**: Composition.author.resolve().ofType(CZ_PractitionerRoleCore)
* **Source Code**: Header.author.identifier (A.1.5.1 - Author identifier)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_PractitionerRoleCore.practictioner.identifier
  * **Comment**: 
* **Source Code**: Header.author.name (A.1.5.2 - Author name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_PractitionerRoleCore.practictioner.name
  * **Comment**: 
* **Source Code**: Header.author.address (A.1.5.3 - Author address)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_PractitionerRoleCore.practictioner.address
  * **Comment**: ID Organization
* **Source Code**: Header.author.organization (A.1.5.4 - Author organisation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Z_PractitionerRoleCore.organization.name
  * **Comment**: 

-------

**Group 7**Mapping from [A.1.5 - Author](StructureDefinition-AuthorCz.md) to [Encounter (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-encounter.html)

* **Source Code**: AuthorCz.organization (A.1.5.4 - Author organisation)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: CZ_Encounter.serviceProvider

-------

**Group 8**Mapping from [A.1.6 - Requested Performer (processing person)](StructureDefinition-RequestedPerformerCz.md) to `https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerRole-core`

* **Source Code**: Header.requestedPerformer (A.1.6 - Requested Performer)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ImagingInformationAboutOrder.performer
* **Source Code**: Header.requestedPerformer.identifier (A.1.6.1 - Requested Performer identifier)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_PractitionerRoleCore.practictioner.identifier
* **Source Code**: Header.requestedPerformer.name (A.1.6.2 - Requested Performer name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_PractitionerRoleCore.practictioner.name
* **Source Code**: Header.requestedPerformer.organizationID (A.1.6.3 - Requested Performer organisation ID)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_PractitionerRoleCore.organization.identifier
* **Source Code**: Header.requestedPerformer.organization (A.1.6.4 - Requested Performer organisation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_PractitionerCore.organization.name

-------

**Group 9**Mapping from [A.1.7 - Additional Recipient](StructureDefinition-AdditionalRecipientCz.md) to `https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerRole-core`

* **Source Code**: Header.additionalRecipient (A.1.7 - Additional Recipient)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.extension:informationRecipient
* **Source Code**: Header.additionalRecipient.identifier (A.1.7.1 - Additional Recipient identifier)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_PractitionerRoleCore.practitioner.identifier
* **Source Code**: Header.additionalRecipient.name (A.1.7.2 - Additional Recipient name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_PractitionerRoleCore.practictioner.name
* **Source Code**: Header.additionalRecipient.organizationID (A.1.7.3 - Additional Recipient organisation ID)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_PractitionerRoleCore.organization.identifier
* **Source Code**: Header.additionalRecipient.organization (A.1.7.4 - Additional Recipient organisation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_PractitionerRoleCore.organization.name

-------

**Group 10**Mapping from [A.1.8 - Document metadata](StructureDefinition-DocumentMetadataCz.md) to [Bundle: Laboratory Order (CZ)](StructureDefinition-BundleLabOrderCz.md)

* **Source Code**: Header.documentMetadata.identifier (A.1.8.1 - Document ID)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.identifier
  * **Comment**: If it is the identifier of a particular order instance
* **Source Code**: Header.documentMetadata.dateTime (A.1.8.4 - Order date and time)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.timeStamp
  * **Comment**: If it is when this particular version of this order has been assembled into a Bundle.

-------

**Group 11**Mapping from `https://hl7.cz/fhir/lab-order/StructureDefinition/LabOrderHeaderCz` to [Composition: Laboratory Order (CZ)](StructureDefinition-cz-CompositionLabOrder.md)

* **Source Code**: Header.subject (A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.subject
  * **Comment**: 
* **Source Code**: Header.author.dateTime (A.1.5.5 - Date Time)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.date
  * **Comment**: 
* **Source Code**: Header.documentMetadata (A.1.8 - Document metadata)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition
  * **Comment**: 
* **Source Code**: Header.documentMetadata.category (A.1.8.2 - Document category)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.category
  * **Comment**: 
* **Source Code**: Header.documentMetadata.status (A.1.8.3 - Document status)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.status
  * **Comment**: 
* **Source Code**: Header.documentMetadata.dateTime (A.1.8.4 - Order date and time)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.date
  * **Comment**: If it is when this document has been created (indipendently by its version)
* **Source Code**: Header.documentMetadata.title (A.1.8.5 - Document title)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.title
  * **Comment**: 
* **Source Code**: Header.documentMetadata.custodian (A.1.8.6 - Order custodian)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.custodian
  * **Comment**: 
* **Source Code**: Header.documentMetadata.confidentiality (A.1.8.7 - Confidentiality)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.confidentiality
  * **Comment**: 
* **Source Code**: Header.documentMetadata.language (A.1.8.8 - Language)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.language
  * **Comment**: 
* **Source Code**: Header.documentMetadata.version (A.1.8.9 - Version)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.extension:versionNumber.valueString
  * **Comment**: As business version, not as resource version

-------

**Group 12**Mapping from `https://hl7.cz/fhir/lab-order/StructureDefinition/digitalSignatureCz` to [Bundle: Laboratory Order (CZ)](StructureDefinition-BundleLabOrderCz.md)

* **Source Code**: Header.digitalSignatureCz.digitalSignature (A.1.9.1 - Electronic signature or document seal)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.signature.data
* **Source Code**: Header.digitalSignatureCz.timestamp (A.1.9.2 - Electronic time stamp)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.signature.when

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

