# CZ Body Model to this guide Map - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CZ Body Model to this guide Map**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-LabOrderBody2FHIR-cz.xml.md) 
*  [JSON](ConceptMap-LabOrderBody2FHIR-cz.json.md) 
*  [TTL](ConceptMap-LabOrderBody2FHIR-cz.ttl.md) 

## ConceptMap: CZ Body Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-order/ConceptMap/LabOrderBody2FHIR-cz | *Version*:0.0.1 |
| Draft as of 2025-10-08 | *Computable Name*:LabOrderBody2FHIRcz |

 
CZ Lab Order Body Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.1 - Order information and A.2.2 - Order reason](StructureDefinition-LabOrderInformationCz.md) to `https://hl7.cz/fhir/img-order/StructureDefinition/cz-serviceRequest`

* **Source Code**: Body.OrderInformation (A.2.1 and A.2.2 - Information about order)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:OrderInformation
  * **Comment**: #Composition.OrderInformation.entry.ofType(CZ_ImagingOrderInformation)
* **Source Code**: OrderInformation.orderDetail (A.2.1 - Order detail)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ImagingOrderInformation
  * **Comment**: 
* **Source Code**: OrderInformation.identifier (A.2.1.1 - Identifier of order detail)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ImagingOrderInformation.identifier
  * **Comment**: 
* **Source Code**: OrderInformation.dateTime (A.2.1.2 - Date and time of the order placement)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ImagingOrderInformation.authoredOn
  * **Comment**: 
* **Source Code**: OrderInformation.requestedExecdateTime (A.2.1.3 - Date and time of requested execution)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ImagingOrderInformation.occurrenceDateTime
  * **Comment**: 
* **Source Code**: OrderInformation.urgency (A.2.1.4 - Urgency of the order)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ImagingOrderInformation.priority
  * **Comment**: 
* **Source Code**: OrderInformation.orderText (A.2.1.5 - Order text)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ImagingOrderInformation.note
  * **Comment**: 
* **Source Code**: OrderInformation.orderText (A.2.1.6 - Information for the patient)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ImagingOrderInformation.patientInstruction
  * **Comment**: 
* **Source Code**: OrderInformation.orderReason (A.2.2 - Order reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ImagingOrderInformation.reasonCode
  * **Comment**: #CZ_ImagingOrderInformation.reasonReference.ofType(CZ_ConditionImage)
* **Source Code**: OrderInformation.orderReason.problem (A.2.2.1 - Problem / diagnosis / condition description)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ImagingOrderInformation.reasonCode.coding
  * **Comment**: 
* **Source Code**: OrderInformation.orderDetail.reasonCode (A.2.2.4 - Reason for ordering by code)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ImagingOrderInformation.reasonCode.coding
  * **Comment**: 
* **Source Code**: OrderInformation.orderDetail.reasonText (A.2.2.6 - Reason for order by text)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ImagingOrderInformation.reasonCode.text
  * **Comment**: 

-------

**Group 2**Mapping from [A.2.1 - Order information and A.2.2 - Order reason](StructureDefinition-LabOrderInformationCz.md) to [Condition: Lab Order (CZ)](StructureDefinition-cz-conditionLab.md)

* **Source Code**: OrderInformation.orderDetail.questionCode (A.2.2.2 - Clinical question in code form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.section:ClinicalQuestion.entry.ofType(CZ_ConditionClinicalQuestion).code (In code form)
* **Source Code**: OrderInformation.orderDetail.questionText (A.2.2.3 - A clinical question in text form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.section:ClinicalQuestion.text (In text form)

-------

**Group 3**Mapping from [A.2.3 - Clinical event (Encounter)](StructureDefinition-ClinicalEventCz.md) to [Encounter (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-encounter.html)

* **Source Code**: Body.ClinicalEvent (A.2.3 - Information about clinical event)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.encounter
  * **Comment**: Composition.encounter.ofType(CZ_Encounter)
* **Source Code**: ClinicalEvent.identifier (A.2.3.1 - Identifier of clinical event)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Encounter.identifier
  * **Comment**: 
* **Source Code**: ClinicalEvent.type (A.2.3.2 - Type of clinical event)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.type (FHIR Document Type Codes (LOINC) or Typ_KU (DASTA))
  * **Comment**: 
* **Source Code**: ClinicalEvent.otherInformation (A.2.3.3 - Other information about clinical event)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Encounter.type.text
  * **Comment**: 

-------

**Group 4**Mapping from [A.2.4 - Information about additional coverage](StructureDefinition-CoverageBodyCz.md) to [Coverage (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)

* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/CoverageBodyCz: Body.coverage
  * : A.2.4 - Information about additional coverage
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-coverage: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * : Composition.section:Coverage
  * ?: 
  * ?: Composition.section:Coverage.entry.ofType(CZ_Coverage)
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/CoverageBodyCz: Body.coverage.method
  * : A.2.4.1 - Coverage method
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-coverage: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Coverage.type
  * ?: 
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/CoverageBodyCz: Body.coverage.informationPayor
  * : A.2.4.3 - Coverage comment
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-coverage: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Coverage.comment
  * ?: 
  * ?: 

-------

**Group 5**Mapping from [A.2.5 - Appointment](StructureDefinition-LabAppointmentCz.md) to [Appointment (CZ)](StructureDefinition-cz-appointment.md)

* **Source Code**: Body.Appointment (A.2.5 - Information about appointment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:Appointment
  * **Comment**: Composition.section:Appointment.entry.ofType(CZ_Appointment)
* **Source Code**: Appointment.identifier (A.2.5.1 - Identifier of appointment)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Appointment.identifier
  * **Comment**: 
* **Source Code**: Appointment.status (A.2.5.2 - Status of appointment)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Appointment.status
  * **Comment**: 
* **Source Code**: Appointment.description (A.2.5.3 - Description of appointment)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Appointment.description
  * **Comment**: 
* **Source Code**: Appointment.dateTime (A.2.5.4 - Date Time)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Appointment.created
  * **Comment**: 
* **Source Code**: Appointment.examDuration (A.2.5.5 - Duration of appointment)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Appointment.minutesDuration
  * **Comment**: 
* **Source Code**: Appointment.comment (A.2.5.6 - Comment about appointment)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Appointment.comment
  * **Comment**: 
* **Source Code**: Appointment.patientInstruction (A.2.5.7 - Instructions for the patient)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Appointment.patientInstruction
  * **Comment**: 
* **Source Code**: Appointment.address (A.2.5.7 - Address of the workplace)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Appointment.Location.address
  * **Comment**: 

-------

**Group 6**Mapping from [A.2.6 - Specimen Information](StructureDefinition-SpecimenInformationCz.md) to [Specimen (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-specimen.html)

* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: Body.SpecimenInformation
  * : A.2.6 - Speciment information
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * : Composition.section:OrderInformation.specimen.ofType(CZ_Specimen)
  * ?: 
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.identifier
  * : A.2.6.1 - Identifier of specimen
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.identifier
  * ?: Identifier of specimen
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.species
  * : A.2.6.2 - Species of animal patient
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.subject.species
  * ?: Species of animal patient
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.material
  * : A.2.6.3 - Type of material
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.type
  * ?: Type of material
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.collectionDate
  * : A.2.6.4 - Date and time of collection
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collection.collectionDate
  * ?: Date and time of collection
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.transportDate
  * : A.2.6.5 - Date and time of transport
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collection.receivedTime
  * ?: Date and time of commencement of transport of the sample to the laboratory
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.type
  * : A.2.6.6 - Sample type
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.type
  * ?: Entities collected for examination.
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.anatomicLocation
  * : A.2.6.7 - Anatomic location
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collection.bodySite
  * ?: Anatomic location (body location, laterality) where the material is collected
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.morphology
  * : A.2.6.8 - Morphology
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collection.extension:bodySite:bodyStructure.morphology
  * ?: Morphological abnormalities of the anatomical location where the material is taken, for example wound, ulcer.
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.instrument
  * : A.2.6.9 - Instrument
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.subject
  * ?: Device, instrument, physical object (drain, electrode, catheter, etc.).
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.procedure
  * : A.2.6.10 - Collection procedure
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collection.method
  * ?: Sampling procedure - for cases where it is relevant to the results.
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.sourceDevice
  * : A.2.6.11 - Source Device
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.subject.type
  * ?: If the material is not collected directly from the patient but comes from a patient-related object, e.g. a catheter
  * ?: Device or Location
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.samplingPoint
  * : A.2.6.12 - Sampling point
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.subject.type
  * ?: The area where the material was collected; refers to the environment, not the patient.
  * ?: Location
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.Note
  * : A.2.6.13 - Note
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.note
  * ?: Note on the material in free text
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.container
  * : A.2.6.14 - Container
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.container
  * ?: 
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.container.type
  * : A.2.6.14.1 - Type
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.container.type
  * ?: Type of sampling container - tube, sampling bag, etc. including chemical additives.
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.container.count
  * : A.2.6.14.2 - Specimen quantity
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.container.specimenQuantity
  * ?: Specimen quantity within container.
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.container.deviceId
  * : A.2.6.14.3 - Device id
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.container.extension:Device:identifier
  * ?: Unique machine-readable container identifier.
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.container.label
  * : A.2.6.14.4 - Label
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collector.description
  * ?: Human readable container identifier.
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.additionalData
  * : A.2.6.15 - Additional formalised sample data
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collection
  * ?: Additional formalised sample data
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.additionalData.date
  * : A.2.6.15.1 - Date
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collection.collectedDateTime
  * ?: Date of discovery of the data, to be indicated if different from the date of the order.
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.additionalData.value
  * : A.2.6.15.3 - Data value
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collection.collectedPeriod
  * ?: Data value including unit of measurement.
  * ?: If #SpecimenInformation.additionalData.code = 08017 or 09056 (NCLPPOL - Čas odběru v minutách nebo sekundách)
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: 
  * : 
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collection.quantity
  * ?: Data value including unit of measurement.
  * ?: If #SpecimenInformation.additionalData.code = 03142 (NCLPPOL - Objem)
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: 
  * : 
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.condition
  * ?: Data value including unit of measurement.
  * ?: If #SpecimenInformation.additionalData.code = 20293 (NCLPPOL - Stav materiálu)
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: 
  * : 
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.note
  * ?: Data value including unit of measurement.
  * ?: If #SpecimenInformation.additionalData.code = 20206 (NCLPPOL - Poznámky-specifikace-jiné)
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.collector
  * : A.2.6.16 - Collector
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collector
  * ?: 
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.collector.identifier
  * : A.2.6.16.1 - Identifier of the sample collector
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collector.identifier
  * ?: Identifier of the sample collector – this refers either to an internal identifier assigned by the healthcare provider or (preferably) a national ID of the healthcare professional, such as a license or registration number. If the sample is not collected by a healthcare professional but, for example, by the patient themselves, an appropriate personal identifier should be used instead.
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.collector.name
  * : A.2.6.16.2 - Name of the sample collector
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collector.name
  * ?: Name of the sample collector
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.collector.contact
  * : A.2.6.16.3 - Contact information of the sample collector
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collector.address
  * ?: Contact information of the sample collector (address and telecommunication data).
  * ?: 
* **Codes**from https://hl7.cz/fhir/lab-order/StructureDefinition/SpecimenInformationCz: SpecimenInformation.collector
  * : A.2.6.16.4 - Organization of the sample collector
  * **Codes**from https://hl7.cz/fhir/core/StructureDefinition/cz-specimen: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * : CZ_Specimen.collector.organization
  * ?: Organization of the sample collector (healthcare provider).
  * ?: 

-------

**Group 7**Mapping from [A.2.7 - Clinical information (anamnesis)](StructureDefinition-ClinicalInformationCz.md) to `https://hl7.cz/fhir/core/StructureDefinition/cz-serviceRequest`

* **Source Code**: Body.clinicalInformation (A.2.7 - Clinical information (anamnesis))
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:OrderInformation.supportingInfo.ofType(Condition)
* **Source Code**: clinicalInformation.clinicalInfoText (A.2.7.1 - Clinical information in free text)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Condition.code.text
* **Source Code**: clinicalInformation.clclinicalInfoFormalized (A.2.7.2 - Clinical information (medical history) formalized)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Condition.code.coding
* **Source Code**: clinicalInformation.description (A.2.7.3 - Description of the problem/diagnosis/condition)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Condition.code.coding

-------

**Group 8**Mapping from [A.2.7 - Clinical information (anamnesis)](StructureDefinition-ClinicalInformationCz.md) to [Medication Statement (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-MedicationStatement.html)

* **Source Code**: clinicalInformation.medication (A.2.7.4 - Medications)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:OrderInformation.supportingInfo.ofType(CZ_MedicationStatement)
* **Source Code**: clinicalInformation.vaccination (A.2.7.5 - Vaccinations)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:OrderInformation.supportingInfo.ofType(CZ_MedicationStatement)

-------

**Group 9**Mapping from [A.2.7 - Clinical information (anamnesis)](StructureDefinition-ClinicalInformationCz.md) to `https://hl7.cz/fhir/core/StructureDefinition/cz-observation`

* **Source Code**: clinicalInformation.finding (A.2.7.6 - Physical findings)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:OrderInformation.supportingInfo.ofType(CZ_ObservationLab)

-------

**Group 10**Mapping from [A.2.7 - Clinical information (anamnesis)](StructureDefinition-ClinicalInformationCz.md) to [Allergy Intolerance (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-allergyIntolerance.html)

* **Source Code**: clinicalInformation.urgentInformation (A.2.7.7 - Urgent information)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:OrderInformation.supportingInfo.ofType(CZ_AllergyIntolerance)
* **Source Code**: clinicalInformation.urgentInformation.allergies (A.2.7.7.1 - Allergies and intolerances)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:OrderInformation.supportingInfo.ofType(CZ_AllergyIntolerance)
* **Source Code**: clinicalInformation.urgentInformation.warnings (A.2.7.7.2 - Warnings)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: clinicalInformations.urgentInformation.warnings

-------

**Group 11**Mapping from [A.2.7 - Clinical information (anamnesis)](StructureDefinition-ClinicalInformationCz.md) to `https://hl7.cz/fhir/core/StructureDefinition/cz-observation`

* **Source Code**: clinicalInformation.additionalData (A.2.7.8 - Additional formalised data)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:OrderInformation.supportingInfo.ofType(CZ_ObservationLab)
* **Source Code**: clinicalInformation.additionalData.date (A.2.7.8.1 - Date)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ObservationLab.dateTime
* **Source Code**: clinicalInformation.additionalData.code (A.2.7.8.2 - Code)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ObservationLab.code
* **Source Code**: clinicalInformation.additionalData.value (A.2.7.8.3 - Data value)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ObservationLab.value

-------

**Group 12**Mapping from `https://hl7.cz/fhir/lab-order/StructureDefinition/LabOrderBodySpecificCz` to `https://hl7.cz/fhir/lab-order/StructureDefinition/cz-service-request`

* **Source Code**: Body.examination (A.2.8 - Laboratory order data elements)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:serviceRequest
* **Source Code**: examination.code (A.2.8.1 - Required examinations)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ServiceRequest.code.coding
* **Source Code**: examination.name (A.2.8.1.2 - Name of examination)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ServiceRequest.code.text
* **Source Code**: examination.procedure (A.2.8.1.3 - Examination procedure)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ServiceRequest
* **Source Code**: examination.accreditation (A.2.8.1.4 - Accreditation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ServiceRequest.extension[accreditation]
* **Source Code**: examination.urgency (A.2.8.1.5 - Urgency)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ServiceRequest.priority
* **Source Code**: examination.note (A.2.8.1.6 - Note)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ServiceRequest.note
* **Source Code**: examination.clinicalEvent (A.2.8.1.7 - Clinical event (encounter))
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_ServiceRequest.encounter

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

