# CZ Attachment Model to this guide Map - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CZ Attachment Model to this guide Map**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-AttachmentLabOrder2FHIR-cz.xml.md) 
*  [JSON](ConceptMap-AttachmentLabOrder2FHIR-cz.json.md) 
*  [TTL](ConceptMap-AttachmentLabOrder2FHIR-cz.ttl.md) 

## ConceptMap: CZ Attachment Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-order/ConceptMap/AttachmentLabOrder2FHIR-cz | *Version*:0.0.1 |
| Draft as of 2025-10-08 | *Computable Name*:AttachmentLabOrder2FHIRcz |

 
CZ Lab Order Attachment Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.3 - Presented form](StructureDefinition-PresentedFormCz.md) to [Attachment Laboratory Order (CZ)](StructureDefinition-cz-attachment.md)

* **Source Code**: PresentedForm (A.3 - Presented Form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Attachment.content
* **Source Code**: PresentedForm.contentType (A.3.1 - Content type of presented form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.contentType
* **Source Code**: PresentedForm.language (A.3.2 - Language of presented form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.language
* **Source Code**: PresentedForm.data (A.3.3 - Data of presented form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.data
* **Source Code**: PresentedForm.url (A.3.4 - URL of presented form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.url
* **Source Code**: PresentedForm.title (A.3.5 - Title of presented form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.title
* **Source Code**: PresentedForm.creation (A.3.6 - Date and time of creation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.creation

-------

**Group 2**Mapping from [A.4 - Attachments](StructureDefinition-AttachmentsCz.md) to [Attachment Laboratory Order (CZ)](StructureDefinition-cz-attachment.md)

* **Source Code**: AttachmentsCz (A.4 - Additional attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Attachment.content
* **Source Code**: AttachmentsCz.contentType (A.4.1 - Content type of additional attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.contentType
* **Source Code**: AttachmentsCz.language (A.4.2 - Language of additional attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.language
* **Source Code**: AttachmentsCz.data (A.4.3 - Data of additional attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.data
* **Source Code**: AttachmentsCz.url (A.4.4 - URL of additional attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.url
* **Source Code**: AttachmentsCz.title (A.4.5 - Title of additional attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.title
* **Source Code**: AttachmentsCz.creation (A.4.6 - Date and time of creation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content.creation

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

