# CZ Lab Order Bundle Example - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CZ Lab Order Bundle Example**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Narrative Content](#) 
*  [XML](Bundle-CZ-LabOrder-Bundle-Example.xml.md) 
*  [JSON](Bundle-CZ-LabOrder-Bundle-Example.json.md) 
*  [TTL](Bundle-CZ-LabOrder-Bundle-Example.ttl.md) 

## Example Bundle: CZ Lab Order Bundle Example

**Document Details**

Profile: [Bundle: Laboratory Order (CZ)](StructureDefinition-BundleLabOrderCz.md)

Final Document at 2025-06-29 10:00:00+0200 by [PractitionerRole Lékař](Bundle-CZ-LabOrder-Bundle-Example.md#urn-uuid-cc8e6b12-2b99-48cf-9c3c-3c8d74805821) for [Virelan Drahovín Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)](Bundle-CZ-LabOrder-Bundle-Example.md#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9) 

-------

**Document Subject**

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Virelan Drahovín Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)

-------

-------

**Document Content**

## Order Information

Order information

## Clinical Question

Clinical question

## Coverage

Coverage

## Additional Documentation

Additional documentation

-------

## Additional Resources Included in Document

-------

Entry 2 - fullUrl = urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9

Resource Patient:

> 

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Virelan Drahovín Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)
-------

-------

Entry 3 - fullUrl = urn:uuid:8d08dca4-bf95-4b46-bcb4-e5b127aa2e30

Resource Coverage:

> 

Profile: [Coverage (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)

**identifier**:`https://ncez.mzcr.cz/fhir/sid/rc`/8001231234 (use: official, )**status**: Active**beneficiary**:[Virelan Drahovín Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)](Bundle-CZ-LabOrder-Bundle-Example.md#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9)

-------

Entry 4 - fullUrl = urn:uuid:fd0cbd93-d65e-47b2-86c9-792268a2c1ff

Resource Organization:

> 

Profile: [Organization (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**identifier**:`https://ncez.mzcr.cz/fhir/sid/ico`/12345678,`https://ncez.mzcr.cz/fhir/sid/krpzs`/ICZ123456**active**: true**name**: Nemocnice Horní Dolní
> **contact****telecom**:[+420555123456](tel:+420555123456),[info@horni-dolni.eu](mailto:info@horni-dolni.eu)**address**: Masarykova 1 Horní Dolní 12345 Česko (work)

-------

Entry 5 - fullUrl = urn:uuid:abcdef12-3456-7890-abcd-1234567890ab

Resource Organization:

> 

Profile: [Organization (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**identifier**:`https://ncez.mzcr.cz/fhir/sid/kp`/111**name**: Všeobecná zdravotní pojišťovna ČR

-------

Entry 6 - fullUrl = urn:uuid:7e243f25-5292-4f5a-9a8c-2a2a9a3e8f7f

Resource Practitioner:

> 

Profile: [Practitioner (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)

**identifier**:`https://ncez.mzcr.cz/fhir/sid/krzp`/123456789**name**: Záboj Šlofák**gender**: Male

-------

Entry 7 - fullUrl = urn:uuid:cc8e6b12-2b99-48cf-9c3c-3c8d74805821

Resource PractitionerRole:

> 

Profile: [Practitioner Role (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)

**active**: true**practitioner**:[Practitioner Záboj Šlofák](Bundle-CZ-LabOrder-Bundle-Example.md#urn-uuid-7e243f25-5292-4f5a-9a8c-2a2a9a3e8f7f)**organization**:[Organization Nemocnice Horní Dolní](Bundle-CZ-LabOrder-Bundle-Example.md#urn-uuid-fd0cbd93-d65e-47b2-86c9-792268a2c1ff)**code**:Lékař

-------

Entry 8 - fullUrl = urn:uuid:3e2c9ab5-fe20-4e52-8bf9-3ff7a384c185

Resource Condition:

> 

Profile: [Clinical question: Laboratory Order (CZ)](StructureDefinition-cz-clinicalQuestion.md)

**identifier**:`http://hospital.example.org/clinical-questions`/CQ-98765**code**:Suspected diabetes mellitus**subject**:[Virelan Drahovín Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)](Bundle-CZ-LabOrder-Bundle-Example.md#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9)

-------

Entry 9 - fullUrl = urn:uuid:c2987da2-94cb-4a6c-bedf-2cb0e817b7dc

Resource Specimen:

> -

-------

Entry 10 - fullUrl = urn:uuid:eb582e83-9558-4578-b332-f009308699bd

Resource ServiceRequest:

> Žádanka na stanovení glukózy v plazmě

-------

Entry 11 - fullUrl = urn:uuid:db28059c-64e2-48ab-9c41-ae0331e0e237

Resource DocumentReference:

> 

Profile: [Attachment Laboratory Order (CZ)](StructureDefinition-cz-attachment.md)


 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

