# Example Appointment – Blood Sample Collection - HL7 Czech Laboratory Order IG v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Appointment – Blood Sample Collection**

HL7 Czech Laboratory Order IG, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.1 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/lab-order/](https://github.com/HL7-cz/lab-order/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/lab-order/history.html)

*  [Narrative Content](#) 
*  [XML](Appointment-AppointmentExample.xml.md) 
*  [JSON](Appointment-AppointmentExample.json.md) 
*  [TTL](Appointment-AppointmentExample.ttl.md) 

## Example Appointment: Example Appointment – Blood Sample Collection

Profile: [Appointment (CZ)](StructureDefinition-cz-appointment.md)

**status**: Booked

**description**: Odběr krve pro biochemické vyšetření

**start**: 2025-07-03 07:15:00+0200

**end**: 2025-07-03 07:30:00+0200

**minutesDuration**: 15

**created**: 2025-06-28 11:30:00+0200

**comment**: Vyšetření zahrnuje krevní obraz a jaterní testy.

**patientInstruction**: Dostavte se nalačno, pouze s vodou. Neužívejte ranní léky bez konzultace s lékařem.

### Participants

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Actor** | **Required** | **Status** |
| * | [Odběrová místnost – Lab s.r.o.](Location-LocationExample.md) | Required | Accepted |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.lab-order#0.0.1 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-08 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

