# hl7.fhir.cz.lab.epi#0.0.1: HL7 Czech Lab Epidemiology Guide

## Pages

* [Home](index.md)
* [Background](background-en.md)
* [Scope and content](scope-and-content-en.md)
* [Background](background-cs.md)
* [Oblasti a obsah](scope-and-content-cs.md)
* [Use cases](use-cases-en.md)
* [Obligations](obligations-en.md)
* [Logical models](logical-models-en.md)
* [Authors](authors-en.md)
* [Obligations](obligations-cs.md)
* [Datová sada - logické modely](logical-models-cs.md)
* [Závislosti](dependencies-cs.md)
* [Download](downloads-en.md)
* [Příklady](examples-cs.md)
* [Autorská práva](copyright-cs.md)
* [Workflow](workflow-en.md)
* [Terminologické aspekty](terminology-considerations-cs.md)
* [Copyright](copyright-en.md)
* [Download](downloads-cs.md)
* [Mapování logického modelu](model-map-cs.md)
* [Workflow](workflow-cs.md)
* [Examples](examples-en.md)
* [Autoři](authors-cs.md)
* [Dependencies](dependencies-en.md)
* [Artifacts Summary](artifacts.md)
* [Terminology considerations](terminology-considerations-en.md)
* [Příklady užití](use-cases-cs.md)
* [Model maps](model-map-en.md)

## Resources

### Logicals

* [SLR – Tělo (CZ)](StructureDefinition-SLRBodyCz.md)
* [SLR – Body (EN)](StructureDefinition-SLRBodyEn.md)
* [SLR – Hlavička (CZ)](StructureDefinition-SLRHeaderCz.md)
* [SLR – Header (EN)](StructureDefinition-SLRHeaderEn.md)

### Resource Profiles

* [Bundle (message) – CZ Lab Report](StructureDefinition-cz-bundle-lab-report-message.md)
* [Coverage – zdravotní pojišťovna](StructureDefinition-cz-lab-coverage.md)
* [MedicationStatement – ATB/ATV před odběrem](StructureDefinition-cz-lab-medicationstatement.md)
* [Organization – CZ Lab (IČO/PCZ/ICP)](StructureDefinition-cz-lab-organization.md)
* [Patient – CZ Lab (RID)](StructureDefinition-cz-lab-patient.md)
* [Practitioner – CZ Lab](StructureDefinition-cz-lab-practitioner.md)
* [ServiceRequest – CZ Lab Order (message context)](StructureDefinition-cz-lab-servicerequest.md)
* [Specimen – CZ Lab](StructureDefinition-cz-lab-specimen.md)
* [DiagnosticReport – CZ Lab Report (message payload)](StructureDefinition-cz-labreport-dr.md)
* [Observation – CZ Lab Result (qual/quant, AST)](StructureDefinition-cz-labresult-obs.md)
* [MessageHeader – CZ Lab Report (message)](StructureDefinition-cz-messageheader-lab-report.md)

### ConceptMaps

* [SLR Body (EN) to CZ Lab (message) mapping](ConceptMap-SLRBodyEn-to-CZLab.md)
* [SLR Header (EN) to CZ Lab (message) mapping](ConceptMap-SLRHeaderEn-to-CZLab.md)

### ImplementationGuides

* [HL7 Czech Lab Epidemiology Guide](index.md)
