# Home - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-epi/ImplementationGuide/hl7.fhir.cz.lab.epi | *Version*:0.0.1 |
| Draft as of 2025-12-19 | *Computable Name*:HL7CzLabEpidemiologyGuide |

### Introduction

This Implementation Guide is based on [FHIR R4](https://hl7.org/fhir/R4/).
 It defines the structure and content of the **Laboratory Result Report Message** in the Czech national context, aligned with the European eHN guidelines.
 The goal is to standardize the electronic format of laboratory result reporting for data exchange between laboratories, healthcare providers, and national systems (e.g., NZIS).

The guide describes

### Content Overview

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction, scope short, references, dependencies, cross version analysis and IP statement for this guide.
* Introduction: 
* [Scope and content](scope-and-content-en.md): This segment contains general information about Laboratory Report.
* [Background](background-en.md): This segment contains background information about Laboratory Report.
 
* Functional: 
* [Use cases](use-cases-en.md): This segment contains information about use cases.
* [Workflow](workflow-en.md): This segment contains information about workflow.
* [Logical models](logical-models-en.md): This segment contains information about logical models.
* [Terminology considerations](terminology-considerations-en.md): This segment contains information about terminology.
 
* Implementation: 
* [Mapping to profiles](model-map-en.md): This segment contains information about logical model maps to profiles.
* [Examples](examples-en.md): This segment contains information about examples.
* [Obligations](obligations-en.md): This segment contains information about obligations.
 
* About: 
* [Authors](authors-en.md): This segment contains informaction about authors.
* [Downloads](downloads-en.md): This segment contains informaction about downloads.
* [Dependencies](dependencies-en.md): This segment contains informaction about dependencies.
* [Copyright](copyright-en.md): This segment contains informaction about copyright.
 
* [Artifacts](artifacts.md): This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### References

* Related specifications: 
* [EHDS Logical Information Models](http://build.fhir.org/ig/Xt-EHR/xt-ehr-common/index.html) 
* This specification has inspired many of the design patterns defined in this IG.
 
* [HL7 Czech Laboratory Order IG](http://build.fhir.org/ig/HL7-cz/lab-order/index.html) 
* This specification has many of together design patterns defined in this IG.
 
* [HL7 Europe Laboratory Report](https://hl7.eu/fhir/laboratory/) 
* This specification has many of together design patterns defined in this IG.
 
* [HL7 Czech Base and Core Implementation Guide](http://build.fhir.org/ig/HL7-cz/cz-core/index.html) 
* Where possible this specification has been aligned with choices made in CZ core.
 
 

### Dependencies
















### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cz.lab.epi.r4)](package.r4.tgz) and [R4B (hl7.fhir.cz.lab.epi.r4b)](package.r4b.tgz) are available.

### IP statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [CZ_BundleLabReportMessage](StructureDefinition-cz-bundle-lab-report-message.md), [CZ_LabReport_DR](StructureDefinition-cz-labreport-dr.md)...Show 16 more,[CZ_LabResult_Obs](StructureDefinition-cz-labresult-obs.md),[CZ_Lab_Coverage](StructureDefinition-cz-lab-coverage.md),[CZ_Lab_MedicationStatement](StructureDefinition-cz-lab-medicationstatement.md),[CZ_Lab_Organization](StructureDefinition-cz-lab-organization.md),[CZ_Lab_Patient](StructureDefinition-cz-lab-patient.md),[CZ_Lab_Practitioner](StructureDefinition-cz-lab-practitioner.md),[CZ_Lab_ServiceRequest](StructureDefinition-cz-lab-servicerequest.md),[CZ_Lab_Specimen](StructureDefinition-cz-lab-specimen.md),[CZ_MessageHeaderLabReport](StructureDefinition-cz-messageheader-lab-report.md),[HL7CzLabEpidemiologyGuide](index.md),[LogCzSLRBody](StructureDefinition-SLRBodyCz.md),[LogCzSLRHeader](StructureDefinition-SLRHeaderCz.md),[LogEnSLRBody](StructureDefinition-SLRBodyEn.md),[LogEnSLRHeader](StructureDefinition-SLRHeaderEn.md),[SLRBodyEnToCZLab](ConceptMap-SLRBodyEn-to-CZLab.md)and[SLRHeaderEnToCZLab](ConceptMap-SLRHeaderEn-to-CZLab.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Observation Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-observation-category.html): [CZ_LabResult_Obs](StructureDefinition-cz-labresult-obs.md)
* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [CZ_Lab_Patient](StructureDefinition-cz-lab-patient.md)


