# Background - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Background**

## Background

## Popis situace

Monitoring infekčních onemocnění v populaci je zásadní pro ochranu veřejného zdraví a pro přijímání opatření, která mohou šíření infekcí zpomalit nebo mu zabránit. Umožňuje rovněž sledovat a předvídat vývoj epidemií a plánovat potřebné kapacity zdravotnického systému.

V případě epidemie je klíčové nastavit **systém včasného varování**, který umožní rychlou reakci na vznikající zdravotní rizika. Takový systém vyžaduje **plnou elektronizaci hlášení** a přímé napojení na informační systémy poskytovatelů zdravotní péče, kteří budou v reálném čase zasílat údaje o výskytu infekčních onemocnění.

Jedním ze tří hlavních pilířů tohoto systému je **hlášení z laboratorních pracovišť**, které zajišťuje průkaz infekčního onemocnění. Zapojenými subjekty jsou mikrobiologické laboratoře, které potvrzují nebo specifikují původce infekce, včetně jeho citlivosti na antibiotika.

Dalšími částmi systému jsou hlášení od nemocničních a ambulantních poskytovatelů zdravotních služeb, které jsou popsány v samostatných dokumentech.

### Obchodní požadavky

Cílem je definovat **datové rozhraní ve formátu HL7 FHIR** pro automatizované hlášení výsledků mikrobiologických vyšetření z laboratorních informačních systémů do centrální databáze **ISIN**, čímž se podpoří datové sběry v rámci projektu **SCOPE-IS**.

Navrhované řešení navazuje na úspěšnou elektronizaci zasílání laboratorních výsledků během pandemie COVID-19. Sběr dat má probíhat v reálném čase, ihned po vyhodnocení laboratorního výsledku, aby systém fungoval jako **early warning systém** — tedy umožnil včasné informování příslušných orgánů o výskytu infekčních onemocnění.

Tento systém doplňuje další sběry dat v projektu SCOPE-IS, které budou probíhat u praktických lékařů a nemocničních zařízení.

### Projekt SCOPE-IS

Projekt **SCOPE-IS** má za cíl vytvořit **systém včasného varování (Early Warning System)** pro vybrané infekční nemoci v České republice, jako součást elektronického **Informačního systému infekčních nemocí (ISIN)**.

Projekt umožní efektivní zadávání a aktualizaci údajů o pacientech s infekčními onemocněními a propojí laboratorní data s daty od ambulantních a nemocničních poskytovatelů. Cílem je vytvořit **robustní systém pro sledování a predikci výskytu infekčních onemocnění**.

