# MessageHeader – CZ Lab Report (message) - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MessageHeader – CZ Lab Report (message)**

## Resource Profile: MessageHeader – CZ Lab Report (message) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-messageheader-lab-report | *Version*:0.0.1 |
| Active as of 2025-12-19 | *Computable Name*:CZ_MessageHeaderLabReport |

 
Message header pro hlášení laboratorního výsledku (message paradigma) 

**Usages:**

* Use this Profile: [Bundle (message) – CZ Lab Report](StructureDefinition-cz-bundle-lab-report-message.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab.epi|current/StructureDefinition/cz-messageheader-lab-report)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-messageheader-lab-report.csv), [Excel](StructureDefinition-cz-messageheader-lab-report.xlsx), [Schematron](StructureDefinition-cz-messageheader-lab-report.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-messageheader-lab-report",
  "url" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-messageheader-lab-report",
  "version" : "0.0.1",
  "name" : "CZ_MessageHeaderLabReport",
  "title" : "MessageHeader – CZ Lab Report (message)",
  "status" : "active",
  "date" : "2025-12-19T07:33:21+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Message header pro hlášení laboratorního výsledku (message paradigma)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MessageHeader",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MessageHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MessageHeader.event[x]",
        "path" : "MessageHeader.event[x]",
        "type" : [
          {
            "code" : "Coding"
          }
        ]
      },
      {
        "id" : "MessageHeader.event[x].system",
        "path" : "MessageHeader.event[x].system",
        "min" : 1,
        "fixedUri" : "https://ncez.mzcr.cz/fhir/cs/events"
      },
      {
        "id" : "MessageHeader.event[x].code",
        "path" : "MessageHeader.event[x].code",
        "min" : 1
      },
      {
        "id" : "MessageHeader.destination",
        "path" : "MessageHeader.destination",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MessageHeader.focus",
        "path" : "MessageHeader.focus",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labreport-dr"
            ]
          }
        ]
      }
    ]
  }
}

```
