# Observation – CZ Lab Result (qual/quant, AST) - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation – CZ Lab Result (qual/quant, AST)**

## Resource Profile: Observation – CZ Lab Result (qual/quant, AST) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labresult-obs | *Version*:0.0.1 |
| Active as of 2025-12-19 | *Computable Name*:CZ_LabResult_Obs |

 
Jednotlivé výsledky včetně kvalitativních a kvantitativních hodnot; AST modelováno per antibiotikum 

**Usages:**

* Use this Profile: [Bundle (message) – CZ Lab Report](StructureDefinition-cz-bundle-lab-report-message.md)
* Refer to this Profile: [DiagnosticReport – CZ Lab Report (message payload)](StructureDefinition-cz-labreport-dr.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab.epi|current/StructureDefinition/cz-labresult-obs)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-labresult-obs.csv), [Excel](StructureDefinition-cz-labresult-obs.xlsx), [Schematron](StructureDefinition-cz-labresult-obs.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-labresult-obs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/laboratory/StructureDefinition/Observation-resultslab-eu-lab"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labresult-obs",
  "version" : "0.0.1",
  "name" : "CZ_LabResult_Obs",
  "title" : "Observation – CZ Lab Result (qual/quant, AST)",
  "status" : "active",
  "date" : "2025-12-19T07:33:21+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Jednotlivé výsledky včetně kvalitativních a kvantitativních hodnot; AST modelováno per antibiotikum",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "inv-obs-qty-ucum",
            "severity" : "error",
            "human" : "If Observation.valueQuantity is present, unit must be UCUM with code",
            "expression" : "valueQuantity.exists() implies (valueQuantity.system = 'http://unitsofmeasure.org' and valueQuantity.code.exists())",
            "source" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labresult-obs"
          },
          {
            "key" : "inv-obs-cutoff",
            "severity" : "warning",
            "human" : "If quantitative result, provide referenceRange.low/high as cut-off when relevant",
            "expression" : "valueQuantity.exists() implies referenceRange.exists()",
            "source" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labresult-obs"
          }
        ]
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "mustSupport" : true
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "mustSupport" : true
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "Observation.method",
        "path" : "Observation.method",
        "mustSupport" : true
      },
      {
        "id" : "Observation.specimen",
        "path" : "Observation.specimen",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-specimen"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.referenceRange",
        "path" : "Observation.referenceRange",
        "mustSupport" : true
      }
    ]
  }
}

```
