# Practitioner – CZ Lab - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Practitioner – CZ Lab**

## Resource Profile: Practitioner – CZ Lab 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-practitioner | *Version*:0.0.1 |
| Active as of 2025-12-19 | *Computable Name*:CZ_Lab_Practitioner |

 
Zdravotnický pracovník (např. kontaktní osoba žadatele / laboratoře) 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab.epi|current/StructureDefinition/cz-lab-practitioner)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-lab-practitioner.csv), [Excel](StructureDefinition-cz-lab-practitioner.xlsx), [Schematron](StructureDefinition-cz-lab-practitioner.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-lab-practitioner",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-practitioner",
  "version" : "0.0.1",
  "name" : "CZ_Lab_Practitioner",
  "title" : "Practitioner – CZ Lab",
  "status" : "active",
  "date" : "2025-12-19T07:33:21+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Zdravotnický pracovník (např. kontaktní osoba žadatele / laboratoře)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner"
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "max" : "1"
      }
    ]
  }
}

```
