# SLR – Header (EN) - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SLR – Header (EN)**

## Logical Model: SLR – Header (EN) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-epi/StructureDefinition/SLRHeaderEn | *Version*:0.0.1 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnSLRHeader |

 
Header of the laboratory result reporting – NZIS. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab.epi|current/StructureDefinition/SLRHeaderEn)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SLRHeaderEn.csv), [Excel](StructureDefinition-SLRHeaderEn.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SLRHeaderEn",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/SLRHeaderEn",
  "version" : "0.0.1",
  "name" : "LogEnSLRHeader",
  "title" : "SLR – Header (EN)",
  "status" : "draft",
  "date" : "2025-12-19T07:33:21+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Header of the laboratory result reporting – NZIS.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/SLRHeaderEn",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "SLRHeaderEn",
        "path" : "SLRHeaderEn",
        "short" : "SLR – Header (EN)",
        "definition" : "Header of the laboratory result reporting – NZIS."
      },
      {
        "id" : "SLRHeaderEn.header",
        "path" : "SLRHeaderEn.header",
        "short" : "SLR – Header (EN)",
        "definition" : "Header of the laboratory result reporting – NZIS.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.identifikacePacienta",
        "path" : "SLRHeaderEn.header.identifikacePacienta",
        "short" : "Identifikace pacienta",
        "definition" : "Identifikace pacienta",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.identifikacePacienta.identifikatorPacienta",
        "path" : "SLRHeaderEn.header.identifikacePacienta.identifikatorPacienta",
        "short" : "Identifikátor pacienta",
        "definition" : "Resortní číslo pacienta (RID). Nejde o číslo pojištěnce ani rodné číslo! K získání RID je nutné použít související vyhledávací API funkce.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.identifikacePacienta.datumNarozeni",
        "path" : "SLRHeaderEn.header.identifikacePacienta.datumNarozeni",
        "short" : "Datum narození",
        "definition" : "Datum narození jako kontrolní doplňující atribut k RID.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.kontaktniInformacePacienta",
        "path" : "SLRHeaderEn.header.kontaktniInformacePacienta",
        "short" : "Kontaktní informace pacienta",
        "definition" : "Kontaktní informace pacienta",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.kontaktniInformacePacienta.adresa",
        "path" : "SLRHeaderEn.header.kontaktniInformacePacienta.adresa",
        "short" : "Adresa",
        "definition" : "Adresa současného pobytu pacienta",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.kontaktniInformacePacienta.telekomunikacniKontaktTelefon",
        "path" : "SLRHeaderEn.header.kontaktniInformacePacienta.telekomunikacniKontaktTelefon",
        "short" : "Telekomunikační kontakt (telefon).",
        "definition" : "Kontaktní telefon na pacienta.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.adresaRuian",
        "path" : "SLRHeaderEn.header.adresaRuian",
        "short" : "Adresa RUIAN",
        "definition" : "Adresní místo současného pobytu pacienta dle RUIAN. Pokud je uvedeno, předchozí položky adresy zůstávají prázdné",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.adresaRuian.uhrada",
        "path" : "SLRHeaderEn.header.adresaRuian.uhrada",
        "short" : "Úhrada",
        "definition" : "Informace o způsobu úhrady objednávky vyšetření",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.adresaRuian.uhrada.zpusobUhrady",
        "path" : "SLRHeaderEn.header.adresaRuian.uhrada.zpusobUhrady",
        "short" : "Způsob úhrady",
        "definition" : "Způsob úhrady objednávky (zdravotní pojištění, hradí pacient, jiný)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.adresaRuian.uhrada.informaceOPlatci",
        "path" : "SLRHeaderEn.header.adresaRuian.uhrada.informaceOPlatci",
        "short" : "Informace o plátci",
        "definition" : "Identifikace zdravotní pojišťovny, na kterou je vyšetření účtování, případně kód pro samoplátce",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.adresaRuian.pracovisteZadatele",
        "path" : "SLRHeaderEn.header.adresaRuian.pracovisteZadatele",
        "short" : "Pracoviště žadatele",
        "definition" : "Žadatelem může být samotná laboratoř",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.adresaRuian.pracovisteZadatele.icoZadatele",
        "path" : "SLRHeaderEn.header.adresaRuian.pracovisteZadatele.icoZadatele",
        "short" : "IČO žadatele",
        "definition" : "IČO žadatele",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.adresaRuian.pracovisteZadatele.pczZadatele",
        "path" : "SLRHeaderEn.header.adresaRuian.pracovisteZadatele.pczZadatele",
        "short" : "PČZ žadatele",
        "definition" : "Kód zdravotnického zařízení dle NRPZS",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.icpZadatele",
        "path" : "SLRHeaderEn.header.icpZadatele",
        "short" : "IČP žadatele",
        "definition" : "Povinné, pokud je vyšetření vykazované na pojišťovnu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.icpZadatele.jmenoAPrijmeniLekare",
        "path" : "SLRHeaderEn.header.icpZadatele.jmenoAPrijmeniLekare",
        "short" : "Jméno a příjmení lékaře",
        "definition" : "Kontaktní osoba v rámci zařízení",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.icpZadatele.pracovisteOdberovehoMista",
        "path" : "SLRHeaderEn.header.icpZadatele.pracovisteOdberovehoMista",
        "short" : "Pracoviště odběrového místa",
        "definition" : "Odběrovým místem může být i žadatel nebo samotná laboratoř",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.icpZadatele.pracovisteOdberovehoMista.icoZadatele",
        "path" : "SLRHeaderEn.header.icpZadatele.pracovisteOdberovehoMista.icoZadatele",
        "short" : "IČO žadatele",
        "definition" : "IČO žadatele",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.icpZadatele.pracovisteOdberovehoMista.pczZadatele",
        "path" : "SLRHeaderEn.header.icpZadatele.pracovisteOdberovehoMista.pczZadatele",
        "short" : "PČZ žadatele",
        "definition" : "Kód zdravotnického zařízení dle NRPZS",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.telekomunikacniKontaktTelefon",
        "path" : "SLRHeaderEn.header.telekomunikacniKontaktTelefon",
        "short" : "Telekomunikační kontakt (telefon).",
        "definition" : "Telekomunikační kontakt (telefon).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.telekomunikacniKontaktTelefon.jmenoAPrijmeniLekare",
        "path" : "SLRHeaderEn.header.telekomunikacniKontaktTelefon.jmenoAPrijmeniLekare",
        "short" : "Jméno a příjmení lékaře",
        "definition" : "Kontaktní osoba v rámci zařízení",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.telekomunikacniKontaktTelefon.metadataDokumentu",
        "path" : "SLRHeaderEn.header.telekomunikacniKontaktTelefon.metadataDokumentu",
        "short" : "Metadata dokumentu",
        "definition" : "Metadata dokumentu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.telekomunikacniKontaktTelefon.metadataDokumentu.cisloVysledku",
        "path" : "SLRHeaderEn.header.telekomunikacniKontaktTelefon.metadataDokumentu.cisloVysledku",
        "short" : "Číslo výsledku",
        "definition" : "Číslo výsledku přidělené centrálním systém. Lze použít pro editaci již nahlášeného výsledku. Pokud null, je založen nový výsledek.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.telekomunikacniKontaktTelefon.metadataDokumentu.cisloZadanky",
        "path" : "SLRHeaderEn.header.telekomunikacniKontaktTelefon.metadataDokumentu.cisloZadanky",
        "short" : "Číslo žádanky",
        "definition" : "Číslo žádanky z elektronického žádankového systému (jakmile bude k dispozici)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRHeaderEn.header.telekomunikacniKontaktTelefon.metadataDokumentu.datumVydani",
        "path" : "SLRHeaderEn.header.telekomunikacniKontaktTelefon.metadataDokumentu.datumVydani",
        "short" : "Datum vydání",
        "definition" : "Datum a čas vydání výsledku laboratoří",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      }
    ]
  }
}

```
