# SLR – Tělo (CZ) - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SLR – Tělo (CZ)**

## Logical Model: SLR – Tělo (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-epi/StructureDefinition/SLRBodyCz | *Version*:0.0.1 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzSLRBody |

 
Tělo hlášení laboratorního výsledku – NZIS. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab.epi|current/StructureDefinition/SLRBodyCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SLRBodyCz.csv), [Excel](StructureDefinition-SLRBodyCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SLRBodyCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/SLRBodyCz",
  "version" : "0.0.1",
  "name" : "LogCzSLRBody",
  "title" : "SLR – Tělo (CZ)",
  "status" : "draft",
  "date" : "2025-12-19T07:33:21+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Tělo hlášení laboratorního výsledku – NZIS.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/SLRBodyCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "SLRBodyCz",
        "path" : "SLRBodyCz",
        "short" : "SLR – Tělo (CZ)",
        "definition" : "Tělo hlášení laboratorního výsledku – NZIS."
      },
      {
        "id" : "SLRBodyCz.telo",
        "path" : "SLRBodyCz.telo",
        "short" : "SLR – Tělo (CZ)",
        "definition" : "Tělo hlášení laboratorního výsledku – NZIS.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.klinickeInformace",
        "path" : "SLRBodyCz.telo.klinickeInformace",
        "short" : "Klinické informace",
        "definition" : "Klinické informace",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.klinickeInformace.diagnoza",
        "path" : "SLRBodyCz.telo.klinickeInformace.diagnoza",
        "short" : "Diagnóza",
        "definition" : "Kód diagnózy dle MKN10 podle žadatele/klinika",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.datumPriznaku",
        "path" : "SLRBodyCz.telo.datumPriznaku",
        "short" : "Datum příznaků",
        "definition" : "Datum prvních příznaků",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.antivirovaAntibiotickaLecbaPredOdberem",
        "path" : "SLRBodyCz.telo.antivirovaAntibiotickaLecbaPredOdberem",
        "short" : "Antivirová/antibiotická léčba před odběrem",
        "definition" : "Informace, zda byla nasazen nějaká relevantní léčba před samotným odběrem. Významná informace i pro laboratoř,",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.datumReceptu",
        "path" : "SLRBodyCz.telo.datumReceptu",
        "short" : "Datum receptu",
        "definition" : "Pokud byla nasazena, údaj o datum vystavení receptu (údaj dostupný v IS žadatele)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.suklKodLeciva",
        "path" : "SLRBodyCz.telo.suklKodLeciva",
        "short" : "SUKL kód léčiva",
        "definition" : "SUKL kód z eReceptu, údaj dostupný v IS žadatele",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.informaceOVzorku",
        "path" : "SLRBodyCz.telo.informaceOVzorku",
        "short" : "Informace o vzorku",
        "definition" : "Informace o vzorku",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.cisloVzorku",
        "path" : "SLRBodyCz.telo.cisloVzorku",
        "short" : "Číslo vzorku",
        "definition" : "Identifikace vzorku dle hlásící laboratoře, umožňuje agregovat nálezy z jednoho vzorku",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.datumOdberu",
        "path" : "SLRBodyCz.telo.datumOdberu",
        "short" : "Datum odběru",
        "definition" : "Datum odběru vzorku",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.material",
        "path" : "SLRBodyCz.telo.material",
        "short" : "Materiál",
        "definition" : "Vyšetřovaný materiál (systém + specifikace)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni",
        "path" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni",
        "short" : "Datové elementy výsledku vyšetření",
        "definition" : "Datové elementy výsledku vyšetření",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni.datumVysetreni",
        "path" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni.datumVysetreni",
        "short" : "Datum vyšetření",
        "definition" : "Datum a čas dokončení vyšetření",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni.metoda",
        "path" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni.metoda",
        "short" : "Metoda",
        "definition" : "Laboratorní metoda (procedura)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni.metodaCil",
        "path" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni.metodaCil",
        "short" : "Metoda cíl",
        "definition" : "Upřesnění metody",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni.agens",
        "path" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni.agens",
        "short" : "Agens",
        "definition" : "Zjišťované agens",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni.vysledek",
        "path" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni.vysledek",
        "short" : "Výsledek",
        "definition" : "Kvalitativní výsledek vyšetření",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni.vysledekKvantitativni",
        "path" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni.vysledekKvantitativni",
        "short" : "Výsledek kvantitativní",
        "definition" : "Kvantitativní výsledek, pokud daná metoda umožňuje stanovit",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni.vysledekJednotka",
        "path" : "SLRBodyCz.telo.material.datoveElementyVysledkuVysetreni.vysledekJednotka",
        "short" : "Výsledek jednotka",
        "definition" : "Jednotka kvantitativního výsledku, povinné, pokud je uveden vysledekKvantitativni",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.material.cutoff",
        "path" : "SLRBodyCz.telo.material.cutoff",
        "short" : "cutOff",
        "definition" : "V případě kvantitativného výsledku, hodnota cut-off pro danou metodu a laboratoř",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.antibiotikum",
        "path" : "SLRBodyCz.telo.antibiotikum",
        "short" : "Antibiotikum",
        "definition" : "V případě bakteriálního nálezu se uvede antibiotikum, na které bylo agens citlivé",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.latka",
        "path" : "SLRBodyCz.telo.latka",
        "short" : "Látka",
        "definition" : "Látka",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRBodyCz.telo.latka.hodnoceni",
        "path" : "SLRBodyCz.telo.latka.hodnoceni",
        "short" : "Hodnocení",
        "definition" : "Hodnocení",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
