# SLR Header (EN) to CZ Lab (message) mapping - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SLR Header (EN) to CZ Lab (message) mapping**

## ConceptMap: SLR Header (EN) to CZ Lab (message) mapping (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-epi/ConceptMap/SLRHeaderEn-to-CZLab | *Version*:0.0.1 |
| Draft as of 2025-12-19 | *Computable Name*:SLRHeaderEnToCZLab |

 
Maps SLR Header logical model to CZ Lab message profiles 

 
Shows how header data elements map to MessageHeader/DiagnosticReport/etc. 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "SLRHeaderEn-to-CZLab",
  "url" : "https://hl7.cz/fhir/lab-epi/ConceptMap/SLRHeaderEn-to-CZLab",
  "version" : "0.0.1",
  "name" : "SLRHeaderEnToCZLab",
  "title" : "SLR Header (EN) to CZ Lab (message) mapping",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-19T07:33:21+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Maps SLR Header logical model to CZ Lab message profiles",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "Shows how header data elements map to MessageHeader/DiagnosticReport/etc.",
  "sourceUri" : "https://example.org/fhir/StructureDefinition/SLRHeaderEn",
  "targetUri" : "https://example.org/fhir/ImplementationGuide/cz-lab-message",
  "group" : [
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRHeaderEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-messageheader-lab-report",
      "element" : [
        {
          "code" : "SLRHeaderEn.header",
          "display" : "Header root",
          "target" : [
            {
              "code" : "MessageHeader",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.informationRecipient",
          "display" : "Information recipient",
          "target" : [
            {
              "code" : "MessageHeader.destination.endpoint",
              "equivalence" : "relatedto",
              "comment" : "Destination system that should receive the message."
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.metadata.dateTime",
          "display" : "Report date and time",
          "target" : [
            {
              "code" : "MessageHeader.timestamp",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRHeaderEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labreport-dr",
      "element" : [
        {
          "code" : "SLRHeaderEn.header.subject",
          "display" : "Patient/subject",
          "target" : [
            {
              "code" : "DiagnosticReport.subject",
              "equivalence" : "equivalent",
              "comment" : "Reference(Patient) → CZ_Lab_Patient"
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.metadata.documentId",
          "display" : "Document Id",
          "target" : [
            {
              "code" : "DiagnosticReport.identifier",
              "equivalence" : "equivalent",
              "comment" : "Business identifier of the lab report (for updates)."
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.metadata.type",
          "display" : "Document type",
          "target" : [
            {
              "code" : "DiagnosticReport.code",
              "equivalence" : "equivalent",
              "comment" : "Prefer LOINC 11502-2 (Laboratory report)."
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.metadata.status",
          "display" : "Document status",
          "target" : [
            {
              "code" : "DiagnosticReport.status",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.metadata.dateTime",
          "display" : "Report date and time",
          "target" : [
            {
              "code" : "DiagnosticReport.issued",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.metadata.language",
          "display" : "Language",
          "target" : [
            {
              "code" : "DiagnosticReport.language",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.author",
          "display" : "Author",
          "target" : [
            {
              "code" : "DiagnosticReport.performer",
              "equivalence" : "relatedto",
              "comment" : "Organization or Practitioner/Role who produced the report."
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.author",
          "display" : "Author (interpreter)",
          "target" : [
            {
              "code" : "DiagnosticReport.resultsInterpreter",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.legalAuthenticator",
          "display" : "Legal authenticator",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "No direct element in message pattern; would map to Composition.attester(mode='legal')."
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.validator",
          "display" : "Result validator",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "No direct element in DR; optional business attribute."
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.metadata.title",
          "display" : "Document title",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "Composition.title in document paradigm."
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.metadata.custodian",
          "display" : "Report custodian",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "Composition.custodian in document paradigm."
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.metadata.confidentiality",
          "display" : "Confidentiality",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "Could be conveyed via meta.security on DR/Bundle; no fixed target here."
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRHeaderEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-patient",
      "element" : [
        {
          "code" : "SLRHeaderEn.header.subject.identifier",
          "display" : "RID (patient identifier)",
          "target" : [
            {
              "code" : "Patient.identifier",
              "equivalence" : "equivalent",
              "comment" : "system=https://ncez.mzcr.cz/fhir/sid/rid"
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.subject.birthDate",
          "display" : "Birth date",
          "target" : [
            {
              "code" : "Patient.birthDate",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.subject.address",
          "display" : "Address (incl. RÚIAN ext)",
          "target" : [
            {
              "code" : "Patient.address",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "SLRHeaderEn.header.subject.telecom",
          "display" : "Phone",
          "target" : [
            {
              "code" : "Patient.telecom",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRHeaderEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-organization",
      "element" : [
        {
          "code" : "SLRHeaderEn.header.informationRecipient.organization",
          "display" : "Recipient organization",
          "target" : [
            {
              "code" : "Organization.identifier",
              "equivalence" : "relatedto",
              "comment" : "IČO/PCZ/ICP identifiers as per CZ_OrganizationCore."
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRHeaderEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-coverage",
      "element" : [
        {
          "code" : "SLRHeaderEn.header.payer",
          "display" : "Health insurance/payment",
          "target" : [
            {
              "code" : "Coverage",
              "equivalence" : "relatedto",
              "comment" : "Coverage.payor → Organization (insurer). Link via ServiceRequest/Claim if used."
            }
          ]
        }
      ]
    }
  ]
}

```
