# Background - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Background**

## Background

## Situation Overview

Monitoring of infectious diseases in the population is essential for public health protection and for implementing measures that can slow down or prevent the spread of infections. It also enables prediction of epidemic trends and planning of healthcare capacities and resources.

In case of an epidemic, it is crucial to establish an **early warning system** that allows a rapid response to emerging health risks. Such a system requires **full electronic reporting** and direct integration with healthcare information systems, enabling real-time submission of infection occurrence data.

One of the three main pillars of this reporting system is **laboratory-based reporting**, which ensures confirmation of infectious diseases. The key actors are microbiological laboratories that identify or specify the infectious agent, including its antibiotic susceptibility.

Other parts of the reporting system include data from hospitals and outpatient providers, which are described in separate documents.

### Business Requirements

The goal is to define a **data interface based on HL7 FHIR** for automated reporting of microbiological test results from laboratory information systems to the central **ISIN** database, thereby supporting data collection within the **SCOPE-IS** project.

The proposed solution builds upon the successful electronic reporting of COVID-19 laboratory results. Data collection should occur in real time, immediately after result evaluation, to support an **early warning system** that promptly informs relevant authorities about infectious disease occurrences.

This reporting process complements other data collection activities under SCOPE-IS, including those from general practitioners and hospital facilities.

### SCOPE-IS Project

The **SCOPE-IS** project aims to establish an **Early Warning System** for selected infectious diseases in the Czech Republic as part of the national **Infectious Diseases Information System (ISIN)**.

The project enables efficient data entry and updates for patients with identified infectious diseases and links laboratory data with information from outpatient and hospital providers, creating a **robust system for early detection and monitoring of infectious diseases**.

