# Artifacts Summary - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [SLR – Body (EN)](StructureDefinition-SLRBodyEn.md) | Body of the laboratory result reporting – NZIS. |
| [SLR – Header (EN)](StructureDefinition-SLRHeaderEn.md) | Header of the laboratory result reporting – NZIS. |
| [SLR – Hlavička (CZ)](StructureDefinition-SLRHeaderCz.md) | Hlavička hlášení laboratorního výsledku – NZIS. |
| [SLR – Tělo (CZ)](StructureDefinition-SLRBodyCz.md) | Tělo hlášení laboratorního výsledku – NZIS. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Bundle (message) – CZ Lab Report](StructureDefinition-cz-bundle-lab-report-message.md) | Message bundle s MessageHeader a DiagnosticReport + souvisejícími zdroji |
| [Coverage – zdravotní pojišťovna](StructureDefinition-cz-lab-coverage.md) | Pokrytí pojištěním pro vykazování (zdravotní pojišťovna, kód) |
| [DiagnosticReport – CZ Lab Report (message payload)](StructureDefinition-cz-labreport-dr.md) | Diagnostický report jako hlavní payload – agregace Observations + odkazy na Pacienta, Vzorek, Žádanku a Laboratoř |
| [MedicationStatement – ATB/ATV před odběrem](StructureDefinition-cz-lab-medicationstatement.md) | Léčba před odběrem – adherence, datum vystavení, SUKL kód |
| [MessageHeader – CZ Lab Report (message)](StructureDefinition-cz-messageheader-lab-report.md) | Message header pro hlášení laboratorního výsledku (message paradigma) |
| [Observation – CZ Lab Result (qual/quant, AST)](StructureDefinition-cz-labresult-obs.md) | Jednotlivé výsledky včetně kvalitativních a kvantitativních hodnot; AST modelováno per antibiotikum |
| [Organization – CZ Lab (IČO/PCZ/ICP)](StructureDefinition-cz-lab-organization.md) | Organizace (žadatel, laboratoř, odběrové místo) s identifikátory IČO/PCZ/ICP |
| [Patient – CZ Lab (RID)](StructureDefinition-cz-lab-patient.md) | Pacient s RID, adresou a kontaktem; pro message kontext |
| [Practitioner – CZ Lab](StructureDefinition-cz-lab-practitioner.md) | Zdravotnický pracovník (např. kontaktní osoba žadatele / laboratoře) |
| [ServiceRequest – CZ Lab Order (message context)](StructureDefinition-cz-lab-servicerequest.md) | Elektronická žádanka; pokud existuje číslo žádanky |
| [Specimen – CZ Lab](StructureDefinition-cz-lab-specimen.md) | Vzorek; identifikace vzorku + typ materiálu + datum odběru + odběrové místo |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [SLR Body (EN) to CZ Lab (message) mapping](ConceptMap-SLRBodyEn-to-CZLab.md) | Maps SLR Body logical model to CZ Lab message profiles |
| [SLR Header (EN) to CZ Lab (message) mapping](ConceptMap-SLRHeaderEn-to-CZLab.md) | Maps SLR Header logical model to CZ Lab message profiles |

