# Specimen – CZ Lab - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Specimen – CZ Lab**

## Resource Profile: Specimen – CZ Lab 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-specimen | *Version*:0.0.1 |
| Active as of 2025-12-19 | *Computable Name*:CZ_Lab_Specimen |

 
Vzorek; identifikace vzorku + typ materiálu + datum odběru + odběrové místo 

**Usages:**

* Use this Profile: [Bundle (message) – CZ Lab Report](StructureDefinition-cz-bundle-lab-report-message.md)
* Refer to this Profile: [DiagnosticReport – CZ Lab Report (message payload)](StructureDefinition-cz-labreport-dr.md) and [Observation – CZ Lab Result (qual/quant, AST)](StructureDefinition-cz-labresult-obs.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab.epi|current/StructureDefinition/cz-lab-specimen)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-lab-specimen.csv), [Excel](StructureDefinition-cz-lab-specimen.xlsx), [Schematron](StructureDefinition-cz-lab-specimen.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-lab-specimen",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/laboratory/StructureDefinition/Specimen-eu-lab"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-specimen",
  "version" : "0.0.1",
  "name" : "CZ_Lab_Specimen",
  "title" : "Specimen – CZ Lab",
  "status" : "active",
  "date" : "2025-12-19T07:33:21+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Vzorek; identifikace vzorku + typ materiálu + datum odběru + odběrové místo",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Specimen",
  "baseDefinition" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-specimen-lab",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Specimen.identifier",
        "path" : "Specimen.identifier",
        "min" : 1
      },
      {
        "id" : "Specimen.type",
        "path" : "Specimen.type",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Specimen.subject",
        "path" : "Specimen.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-patient"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.collection.collected[x]",
        "path" : "Specimen.collection.collected[x]",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Specimen.collection.bodySite",
        "path" : "Specimen.collection.bodySite",
        "max" : "0"
      }
    ]
  }
}

```
