# Patient – CZ Lab (RID) - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient – CZ Lab (RID)**

## Resource Profile: Patient – CZ Lab (RID) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-patient | *Version*:0.0.1 |
| Active as of 2025-12-19 | *Computable Name*:CZ_Lab_Patient |

 
Pacient s RID, adresou a kontaktem; pro message kontext 

**Usages:**

* Refer to this Profile: [Specimen – CZ Lab](StructureDefinition-cz-lab-specimen.md), [DiagnosticReport – CZ Lab Report (message payload)](StructureDefinition-cz-labreport-dr.md) and [Observation – CZ Lab Result (qual/quant, AST)](StructureDefinition-cz-labresult-obs.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab.epi|current/StructureDefinition/cz-lab-patient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-lab-patient.csv), [Excel](StructureDefinition-cz-lab-patient.xlsx), [Schematron](StructureDefinition-cz-lab-patient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-lab-patient",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-patient",
  "version" : "0.0.1",
  "name" : "CZ_Lab_Patient",
  "title" : "Patient – CZ Lab (RID)",
  "status" : "active",
  "date" : "2025-12-19T07:33:21+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Pacient s RID, adresou a kontaktem; pro message kontext",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "constraint" : [
          {
            "key" : "inv-patient-rid-bd",
            "severity" : "warning",
            "human" : "Patient SHOULD carry RID and birthDate",
            "expression" : "identifier.where(system = 'https://ncez.mzcr.cz/fhir/sid/rid').exists() and birthDate.exists()",
            "source" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-patient"
          }
        ]
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "mustSupport" : true
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "mustSupport" : true
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "max" : "1",
        "mustSupport" : true
      }
    ]
  }
}

```
