# Organization – CZ Lab (IČO/PCZ/ICP) - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization – CZ Lab (IČO/PCZ/ICP)**

## Resource Profile: Organization – CZ Lab (IČO/PCZ/ICP) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-organization | *Version*:0.0.1 |
| Active as of 2025-12-19 | *Computable Name*:CZ_Lab_Organization |

 
Organizace (žadatel, laboratoř, odběrové místo) s identifikátory IČO/PCZ/ICP 

**Usages:**

* Refer to this Profile: [DiagnosticReport – CZ Lab Report (message payload)](StructureDefinition-cz-labreport-dr.md) and [Observation – CZ Lab Result (qual/quant, AST)](StructureDefinition-cz-labresult-obs.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab.epi|current/StructureDefinition/cz-lab-organization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-lab-organization.csv), [Excel](StructureDefinition-cz-lab-organization.xlsx), [Schematron](StructureDefinition-cz-lab-organization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-lab-organization",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-organization",
  "version" : "0.0.1",
  "name" : "CZ_Lab_Organization",
  "title" : "Organization – CZ Lab (IČO/PCZ/ICP)",
  "status" : "active",
  "date" : "2025-12-19T07:33:21+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Organizace (žadatel, laboratoř, odběrové místo) s identifikátory IČO/PCZ/ICP",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
