# Bundle (message) – CZ Lab Report - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle (message) – CZ Lab Report**

## Resource Profile: Bundle (message) – CZ Lab Report 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-bundle-lab-report-message | *Version*:0.0.1 |
| Active as of 2025-12-19 | *Computable Name*:CZ_BundleLabReportMessage |

 
Message bundle s MessageHeader a DiagnosticReport + souvisejícími zdroji 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab.epi|current/StructureDefinition/cz-bundle-lab-report-message)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-bundle-lab-report-message.csv), [Excel](StructureDefinition-cz-bundle-lab-report-message.xlsx), [Schematron](StructureDefinition-cz-bundle-lab-report-message.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-bundle-lab-report-message",
  "url" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-bundle-lab-report-message",
  "version" : "0.0.1",
  "name" : "CZ_BundleLabReportMessage",
  "title" : "Bundle (message) – CZ Lab Report",
  "status" : "active",
  "date" : "2025-12-19T07:33:21+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Message bundle s MessageHeader a DiagnosticReport + souvisejícími zdroji",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "constraint" : [
          {
            "key" : "inv-msg-one-mh",
            "severity" : "error",
            "human" : "Bundle(message) MUST contain exactly one MessageHeader as first entry",
            "expression" : "entry.first().resource is MessageHeader",
            "source" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-bundle-lab-report-message"
          }
        ]
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "fixedCode" : "message"
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "min" : 1
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resource"
            }
          ],
          "description" : "První slice je MessageHeader, další jsou payload resources.",
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Bundle.entry.link",
        "path" : "Bundle.entry.link",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1
      },
      {
        "id" : "Bundle.entry:header",
        "path" : "Bundle.entry",
        "sliceName" : "header",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:header.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MessageHeader",
            "profile" : [
              "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-messageheader-lab-report"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:body",
        "path" : "Bundle.entry",
        "sliceName" : "body",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:body.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "DiagnosticReport",
            "profile" : [
              "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labreport-dr"
            ]
          },
          {
            "code" : "Observation",
            "profile" : [
              "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labresult-obs"
            ]
          },
          {
            "code" : "Specimen",
            "profile" : [
              "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-specimen"
            ]
          },
          {
            "code" : "ServiceRequest",
            "profile" : [
              "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-servicerequest"
            ]
          },
          {
            "code" : "Coverage",
            "profile" : [
              "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-coverage"
            ]
          }
        ]
      }
    ]
  }
}

```
