# SLR – Hlavička (CZ) - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SLR – Hlavička (CZ)**

## Logical Model: SLR – Hlavička (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-epi/StructureDefinition/SLRHeaderCz | *Version*:0.0.1 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzSLRHeader |

 
Hlavička hlášení laboratorního výsledku – NZIS. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab.epi|current/StructureDefinition/SLRHeaderCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SLRHeaderCz.csv), [Excel](StructureDefinition-SLRHeaderCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SLRHeaderCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/SLRHeaderCz",
  "version" : "0.0.1",
  "name" : "LogCzSLRHeader",
  "title" : "SLR – Hlavička (CZ)",
  "status" : "draft",
  "date" : "2025-12-19T07:33:21+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Hlavička hlášení laboratorního výsledku – NZIS.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/SLRHeaderCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "SLRHeaderCz",
        "path" : "SLRHeaderCz",
        "short" : "SLR – Hlavička (CZ)",
        "definition" : "Hlavička hlášení laboratorního výsledku – NZIS."
      },
      {
        "id" : "SLRHeaderCz.hlavicka",
        "path" : "SLRHeaderCz.hlavicka",
        "short" : "SLR – Hlavička (CZ)",
        "definition" : "Hlavička hlášení laboratorního výsledku – NZIS.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.identifikacePacienta",
        "path" : "SLRHeaderCz.hlavicka.identifikacePacienta",
        "short" : "Identifikace pacienta",
        "definition" : "Identifikace pacienta",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.identifikacePacienta.identifikatorPacienta",
        "path" : "SLRHeaderCz.hlavicka.identifikacePacienta.identifikatorPacienta",
        "short" : "Identifikátor pacienta",
        "definition" : "Resortní číslo pacienta (RID). Nejde o číslo pojištěnce ani rodné číslo! K získání RID je nutné použít související vyhledávací API funkce.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.identifikacePacienta.datumNarozeni",
        "path" : "SLRHeaderCz.hlavicka.identifikacePacienta.datumNarozeni",
        "short" : "Datum narození",
        "definition" : "Datum narození jako kontrolní doplňující atribut k RID.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.kontaktniInformacePacienta",
        "path" : "SLRHeaderCz.hlavicka.kontaktniInformacePacienta",
        "short" : "Kontaktní informace pacienta",
        "definition" : "Kontaktní informace pacienta",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.kontaktniInformacePacienta.adresa",
        "path" : "SLRHeaderCz.hlavicka.kontaktniInformacePacienta.adresa",
        "short" : "Adresa",
        "definition" : "Adresa současného pobytu pacienta",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.kontaktniInformacePacienta.telekomunikacniKontaktTelefon",
        "path" : "SLRHeaderCz.hlavicka.kontaktniInformacePacienta.telekomunikacniKontaktTelefon",
        "short" : "Telekomunikační kontakt (telefon).",
        "definition" : "Kontaktní telefon na pacienta.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.adresaRuian",
        "path" : "SLRHeaderCz.hlavicka.adresaRuian",
        "short" : "Adresa RUIAN",
        "definition" : "Adresní místo současného pobytu pacienta dle RUIAN. Pokud je uvedeno, předchozí položky adresy zůstávají prázdné",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.adresaRuian.uhrada",
        "path" : "SLRHeaderCz.hlavicka.adresaRuian.uhrada",
        "short" : "Úhrada",
        "definition" : "Informace o způsobu úhrady objednávky vyšetření",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.adresaRuian.uhrada.zpusobUhrady",
        "path" : "SLRHeaderCz.hlavicka.adresaRuian.uhrada.zpusobUhrady",
        "short" : "Způsob úhrady",
        "definition" : "Způsob úhrady objednávky (zdravotní pojištění, hradí pacient, jiný)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.adresaRuian.uhrada.informaceOPlatci",
        "path" : "SLRHeaderCz.hlavicka.adresaRuian.uhrada.informaceOPlatci",
        "short" : "Informace o plátci",
        "definition" : "Identifikace zdravotní pojišťovny, na kterou je vyšetření účtování, případně kód pro samoplátce",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.adresaRuian.pracovisteZadatele",
        "path" : "SLRHeaderCz.hlavicka.adresaRuian.pracovisteZadatele",
        "short" : "Pracoviště žadatele",
        "definition" : "Žadatelem může být samotná laboratoř",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.adresaRuian.pracovisteZadatele.icoZadatele",
        "path" : "SLRHeaderCz.hlavicka.adresaRuian.pracovisteZadatele.icoZadatele",
        "short" : "IČO žadatele",
        "definition" : "IČO žadatele",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.adresaRuian.pracovisteZadatele.pczZadatele",
        "path" : "SLRHeaderCz.hlavicka.adresaRuian.pracovisteZadatele.pczZadatele",
        "short" : "PČZ žadatele",
        "definition" : "Kód zdravotnického zařízení dle NRPZS",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.icpZadatele",
        "path" : "SLRHeaderCz.hlavicka.icpZadatele",
        "short" : "IČP žadatele",
        "definition" : "Povinné, pokud je vyšetření vykazované na pojišťovnu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.icpZadatele.jmenoAPrijmeniLekare",
        "path" : "SLRHeaderCz.hlavicka.icpZadatele.jmenoAPrijmeniLekare",
        "short" : "Jméno a příjmení lékaře",
        "definition" : "Kontaktní osoba v rámci zařízení",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.icpZadatele.pracovisteOdberovehoMista",
        "path" : "SLRHeaderCz.hlavicka.icpZadatele.pracovisteOdberovehoMista",
        "short" : "Pracoviště odběrového místa",
        "definition" : "Odběrovým místem může být i žadatel nebo samotná laboratoř",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.icpZadatele.pracovisteOdberovehoMista.icoZadatele",
        "path" : "SLRHeaderCz.hlavicka.icpZadatele.pracovisteOdberovehoMista.icoZadatele",
        "short" : "IČO žadatele",
        "definition" : "IČO žadatele",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.icpZadatele.pracovisteOdberovehoMista.pczZadatele",
        "path" : "SLRHeaderCz.hlavicka.icpZadatele.pracovisteOdberovehoMista.pczZadatele",
        "short" : "PČZ žadatele",
        "definition" : "Kód zdravotnického zařízení dle NRPZS",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.telekomunikacniKontaktTelefon",
        "path" : "SLRHeaderCz.hlavicka.telekomunikacniKontaktTelefon",
        "short" : "Telekomunikační kontakt (telefon).",
        "definition" : "Telekomunikační kontakt (telefon).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.telekomunikacniKontaktTelefon.jmenoAPrijmeniLekare",
        "path" : "SLRHeaderCz.hlavicka.telekomunikacniKontaktTelefon.jmenoAPrijmeniLekare",
        "short" : "Jméno a příjmení lékaře",
        "definition" : "Kontaktní osoba v rámci zařízení",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.telekomunikacniKontaktTelefon.metadataDokumentu",
        "path" : "SLRHeaderCz.hlavicka.telekomunikacniKontaktTelefon.metadataDokumentu",
        "short" : "Metadata dokumentu",
        "definition" : "Metadata dokumentu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.telekomunikacniKontaktTelefon.metadataDokumentu.cisloVysledku",
        "path" : "SLRHeaderCz.hlavicka.telekomunikacniKontaktTelefon.metadataDokumentu.cisloVysledku",
        "short" : "Číslo výsledku",
        "definition" : "Číslo výsledku přidělené centrálním systém. Lze použít pro editaci již nahlášeného výsledku. Pokud null, je založen nový výsledek.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.telekomunikacniKontaktTelefon.metadataDokumentu.cisloZadanky",
        "path" : "SLRHeaderCz.hlavicka.telekomunikacniKontaktTelefon.metadataDokumentu.cisloZadanky",
        "short" : "Číslo žádanky",
        "definition" : "Číslo žádanky z elektronického žádankového systému (jakmile bude k dispozici)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRHeaderCz.hlavicka.telekomunikacniKontaktTelefon.metadataDokumentu.datumVydani",
        "path" : "SLRHeaderCz.hlavicka.telekomunikacniKontaktTelefon.metadataDokumentu.datumVydani",
        "short" : "Datum vydání",
        "definition" : "Datum a čas vydání výsledku laboratoří",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      }
    ]
  }
}

```
