# SLR – Body (EN) - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SLR – Body (EN)**

## Logical Model: SLR – Body (EN) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-epi/StructureDefinition/SLRBodyEn | *Version*:0.0.1 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnSLRBody |

 
Body of the laboratory result reporting – NZIS. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab.epi|current/StructureDefinition/SLRBodyEn)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SLRBodyEn.csv), [Excel](StructureDefinition-SLRBodyEn.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SLRBodyEn",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/SLRBodyEn",
  "version" : "0.0.1",
  "name" : "LogEnSLRBody",
  "title" : "SLR – Body (EN)",
  "status" : "draft",
  "date" : "2025-12-19T07:33:21+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Body of the laboratory result reporting – NZIS.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/SLRBodyEn",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "SLRBodyEn",
        "path" : "SLRBodyEn",
        "short" : "SLR – Body (EN)",
        "definition" : "Body of the laboratory result reporting – NZIS."
      },
      {
        "id" : "SLRBodyEn.body",
        "path" : "SLRBodyEn.body",
        "short" : "SLR – Body (EN)",
        "definition" : "Body of the laboratory result reporting – NZIS.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.klinickeInformace",
        "path" : "SLRBodyEn.body.klinickeInformace",
        "short" : "Klinické informace",
        "definition" : "Klinické informace",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.klinickeInformace.diagnoza",
        "path" : "SLRBodyEn.body.klinickeInformace.diagnoza",
        "short" : "Diagnóza",
        "definition" : "Kód diagnózy dle MKN10 podle žadatele/klinika",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.datumPriznaku",
        "path" : "SLRBodyEn.body.datumPriznaku",
        "short" : "Datum příznaků",
        "definition" : "Datum prvních příznaků",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.antivirovaAntibiotickaLecbaPredOdberem",
        "path" : "SLRBodyEn.body.antivirovaAntibiotickaLecbaPredOdberem",
        "short" : "Antivirová/antibiotická léčba před odběrem",
        "definition" : "Informace, zda byla nasazen nějaká relevantní léčba před samotným odběrem. Významná informace i pro laboratoř,",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.datumReceptu",
        "path" : "SLRBodyEn.body.datumReceptu",
        "short" : "Datum receptu",
        "definition" : "Pokud byla nasazena, údaj o datum vystavení receptu (údaj dostupný v IS žadatele)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.suklKodLeciva",
        "path" : "SLRBodyEn.body.suklKodLeciva",
        "short" : "SUKL kód léčiva",
        "definition" : "SUKL kód z eReceptu, údaj dostupný v IS žadatele",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.informaceOVzorku",
        "path" : "SLRBodyEn.body.informaceOVzorku",
        "short" : "Informace o vzorku",
        "definition" : "Informace o vzorku",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.cisloVzorku",
        "path" : "SLRBodyEn.body.cisloVzorku",
        "short" : "Číslo vzorku",
        "definition" : "Identifikace vzorku dle hlásící laboratoře, umožňuje agregovat nálezy z jednoho vzorku",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.datumOdberu",
        "path" : "SLRBodyEn.body.datumOdberu",
        "short" : "Datum odběru",
        "definition" : "Datum odběru vzorku",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.material",
        "path" : "SLRBodyEn.body.material",
        "short" : "Materiál",
        "definition" : "Vyšetřovaný materiál (systém + specifikace)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni",
        "path" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni",
        "short" : "Datové elementy výsledku vyšetření",
        "definition" : "Datové elementy výsledku vyšetření",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni.datumVysetreni",
        "path" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni.datumVysetreni",
        "short" : "Datum vyšetření",
        "definition" : "Datum a čas dokončení vyšetření",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni.metoda",
        "path" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni.metoda",
        "short" : "Metoda",
        "definition" : "Laboratorní metoda (procedura)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni.metodaCil",
        "path" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni.metodaCil",
        "short" : "Metoda cíl",
        "definition" : "Upřesnění metody",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni.agens",
        "path" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni.agens",
        "short" : "Agens",
        "definition" : "Zjišťované agens",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni.vysledek",
        "path" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni.vysledek",
        "short" : "Výsledek",
        "definition" : "Kvalitativní výsledek vyšetření",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni.vysledekKvantitativni",
        "path" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni.vysledekKvantitativni",
        "short" : "Výsledek kvantitativní",
        "definition" : "Kvantitativní výsledek, pokud daná metoda umožňuje stanovit",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni.vysledekJednotka",
        "path" : "SLRBodyEn.body.material.datoveElementyVysledkuVysetreni.vysledekJednotka",
        "short" : "Výsledek jednotka",
        "definition" : "Jednotka kvantitativního výsledku, povinné, pokud je uveden vysledekKvantitativni",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.material.cutoff",
        "path" : "SLRBodyEn.body.material.cutoff",
        "short" : "cutOff",
        "definition" : "V případě kvantitativného výsledku, hodnota cut-off pro danou metodu a laboratoř",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.antibiotikum",
        "path" : "SLRBodyEn.body.antibiotikum",
        "short" : "Antibiotikum",
        "definition" : "V případě bakteriálního nálezu se uvede antibiotikum, na které bylo agens citlivé",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.latka",
        "path" : "SLRBodyEn.body.latka",
        "short" : "Látka",
        "definition" : "Látka",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SLRBodyEn.body.latka.hodnoceni",
        "path" : "SLRBodyEn.body.latka.hodnoceni",
        "short" : "Hodnocení",
        "definition" : "Hodnocení",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
