# SLR Body (EN) to CZ Lab (message) mapping - HL7 Czech Lab Epidemiology Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SLR Body (EN) to CZ Lab (message) mapping**

## ConceptMap: SLR Body (EN) to CZ Lab (message) mapping (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab-epi/ConceptMap/SLRBodyEn-to-CZLab | *Version*:0.0.1 |
| Draft as of 2025-12-19 | *Computable Name*:SLRBodyEnToCZLab |

 
Maps SLR Body logical model to CZ Lab message profiles 

 
Shows how body data elements map to ServiceRequest/Specimen/DiagnosticReport/Observation/etc. 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "SLRBodyEn-to-CZLab",
  "url" : "https://hl7.cz/fhir/lab-epi/ConceptMap/SLRBodyEn-to-CZLab",
  "version" : "0.0.1",
  "name" : "SLRBodyEnToCZLab",
  "title" : "SLR Body (EN) to CZ Lab (message) mapping",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-19T07:33:21+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Maps SLR Body logical model to CZ Lab message profiles",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "Shows how body data elements map to ServiceRequest/Specimen/DiagnosticReport/Observation/etc.",
  "sourceUri" : "https://example.org/fhir/StructureDefinition/SLRBodyEn",
  "targetUri" : "https://example.org/fhir/ImplementationGuide/cz-lab-message",
  "group" : [
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRBodyEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-servicerequest",
      "element" : [
        {
          "code" : "SLRBodyEn.body.order.identifier",
          "display" : "Order number",
          "target" : [
            {
              "code" : "ServiceRequest.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SLRBodyEn.body.order.reason",
          "display" : "Order reason (diagnosis)",
          "target" : [
            {
              "code" : "ServiceRequest.reasonCode",
              "equivalence" : "equivalent",
              "comment" : "ICD-10 (MKN-10) where applicable."
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRBodyEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labreport-dr",
      "element" : [
        {
          "code" : "SLRBodyEn.body.order",
          "display" : "Order",
          "target" : [
            {
              "code" : "DiagnosticReport.basedOn",
              "equivalence" : "relatedto",
              "comment" : "Reference(ServiceRequest)."
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRBodyEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-specimen",
      "element" : [
        {
          "code" : "SLRBodyEn.body.specimen.sampleNumber",
          "display" : "Sample identifier",
          "target" : [
            {
              "code" : "Specimen.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SLRBodyEn.body.specimen.collectionDate",
          "display" : "Collection date/time",
          "target" : [
            {
              "code" : "Specimen.collection.collectedDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SLRBodyEn.body.specimen.material",
          "display" : "Material (Specimen type)",
          "target" : [
            {
              "code" : "Specimen.type",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRBodyEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labreport-dr",
      "element" : [
        {
          "code" : "SLRBodyEn.body.specimen",
          "display" : "Specimen info",
          "target" : [
            {
              "code" : "DiagnosticReport.specimen",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRBodyEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labresult-obs",
      "element" : [
        {
          "code" : "SLRBodyEn.body.specimen",
          "display" : "Specimen info",
          "target" : [
            {
              "code" : "Observation.specimen",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRBodyEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labresult-obs",
      "element" : [
        {
          "code" : "SLRBodyEn.body.result.examDate",
          "display" : "Examination date/time",
          "target" : [
            {
              "code" : "Observation.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SLRBodyEn.body.result.method",
          "display" : "Method",
          "target" : [
            {
              "code" : "Observation.method",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "SLRBodyEn.body.result.analyteOrAgent",
          "display" : "Analyte / Agent",
          "target" : [
            {
              "code" : "Observation.code",
              "equivalence" : "equivalent",
              "comment" : "Tested analyte/agent (e.g., detection of pathogen)."
            }
          ]
        },
        {
          "code" : "SLRBodyEn.body.result.qualitativeResult",
          "display" : "Qualitative result",
          "target" : [
            {
              "code" : "Observation.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SLRBodyEn.body.result.quantitativeResult.value",
          "display" : "Quantitative value",
          "target" : [
            {
              "code" : "Observation.valueQuantity",
              "equivalence" : "equivalent",
              "comment" : "Use UCUM units."
            }
          ]
        },
        {
          "code" : "SLRBodyEn.body.result.quantitativeResult.unit",
          "display" : "Unit (UCUM)",
          "target" : [
            {
              "code" : "Observation.valueQuantity.unit",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "SLRBodyEn.body.result.cutOff",
          "display" : "Cut-off",
          "target" : [
            {
              "code" : "Observation.referenceRange",
              "equivalence" : "relatedto",
              "comment" : "Model cut-off in referenceRange.low/high."
            }
          ]
        },
        {
          "code" : "SLRBodyEn.body.result.antibiotic",
          "display" : "Antibiotic susceptibility (S/I/R)",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "Model as multiple Observations (code=susceptibility test, value=S/I/R)."
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRBodyEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labreport-dr",
      "element" : [
        {
          "code" : "SLRBodyEn.body.result",
          "display" : "Results",
          "target" : [
            {
              "code" : "DiagnosticReport.result",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRBodyEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-medicationstatement",
      "element" : [
        {
          "code" : "SLRBodyEn.body.clinicalInformation.priorTherapy",
          "display" : "Antiviral/antibiotic therapy before collection",
          "target" : [
            {
              "code" : "MedicationStatement",
              "equivalence" : "relatedto",
              "comment" : "Use adherence/effective[x]/medicationCodeableConcept (SÚKL)."
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRBodyEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-patient",
      "element" : [
        {
          "code" : "SLRBodyEn.body.clinicalInformation.symptomOnset",
          "display" : "Symptom onset date",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "Prefer Condition.onsetDateTime or a dedicated Observation; extension here only if required."
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRBodyEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-lab-organization",
      "element" : [
        {
          "code" : "SLRBodyEn.body.laboratory.organizationIdentifiers",
          "display" : "Lab organization IČO/PCZ/ICP",
          "target" : [
            {
              "code" : "Organization.identifier",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRBodyEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labreport-dr",
      "element" : [
        {
          "code" : "SLRBodyEn.body.laboratory",
          "display" : "Performing laboratory",
          "target" : [
            {
              "code" : "DiagnosticReport.performer",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://example.org/fhir/StructureDefinition/SLRBodyEn",
      "target" : "https://hl7.cz/fhir/lab-epi/StructureDefinition/cz-labreport-dr",
      "element" : [
        {
          "code" : "SLRBodyEn.body.presentedForm",
          "display" : "Presented form (PDF, etc.)",
          "target" : [
            {
              "code" : "DiagnosticReport.presentedForm",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "SLRBodyEn.body.attachments",
          "display" : "Additional attachments",
          "target" : [
            {
              "code" : "DiagnosticReport.media.link.content.attachment",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    }
  ]
}

```
