# Home - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/ImplementationGuide/hl7.fhir.cz.img-order | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:HL7CzImagingOrderImplementationGuide |

### Introduction

This implementation guide is based on [FHIR version R4](https://hl7.org/fhir/R4/). Specify a set of rules that will be used for HL7 FHIR to define how to represent Imaging Order in the Czech national context, in line with European eHN guidelines.

Its main objective is to define the content components and the preferred structure to be used to construct a imaging order. The purpose of this standard is to define the representation of the imaging order as a patient's medical record for the purpose of electronic exchange of health information between individuals, healthcare providers and infrastructure in the Czech Republic.

This guide does not describe how to exchange this message.

### Scope

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction, scope short, references, dependencies, cross version analysis and IP statement for this guide.
* Introduction: 
* [Scope and content](scope-and-content.md): This segment contains general information about Imaging order.
* [Background](background.md): This segment contains background information about Imaging order.
 
* Functional: 
* [Use cases](use-cases.md): This segment contains information about use cases.
* [Workflow](workflow.md): This segment contains information about workflow.
* [Logical models](logical-models.md): This segment contains information about logical models.
* [Terminology considerations](terminology-considerations.md): This segment contains information about terminology.
 
* Implementation: 
* [Mapping to profiles](model-map.md): This segment contains information about logical model maps to profiles.
* [Examples](examples.md): This segment contains information about examples.
* [Obligations](obligations.md): This segment contains information about obligations.
* [Implementation notes](implementation-notes.md): This segment contains information for implementation.
 
* About: 
* [Authors](authors.md): This segment contains informaction about authors.
* [Downloads](downloads.md): This segment contains informaction about downloads.
* [Dependencies](dependencies.md): This segment contains informaction about dependencies.
* [Copyright](copyright.md): This segment contains informaction about copyright.
 
* [Artifacts](artifacts.md): This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### References

The paper form template for an electronic referral is the paper referral form for Examination/Treatment Type Z. The specifications for the content of the paper referral are provided in `příloha č. 1 v části 2 k vyhlášce č. 444/2024 Sb., o zdravotnické dokumentaci, k 19.2.2025`.

* Related specifications: 
* [EHDS Logical Information Models](http://build.fhir.org/ig/Xt-EHR/xt-ehr-common/index.html) 
* This specification has inspired many of the design patterns defined in this IG.
 
* [HL7 Czech Laboratory Order IG](http://build.fhir.org/ig/HL7-cz/lab-order/index.html) 
* This specification has many of together design patterns defined in this IG.
 
* [HL7 Czech Imaging Report IG](http://build.fhir.org/ig/HL7-cz/img/index.html) 
* This specification has many of together design patterns defined in this IG.
 
* [HL7 Czech Base and Core Implementation Guide](http://build.fhir.org/ig/HL7-cz/cz-core/index.html) 
* Where possible this specification has been aligned with choices made in CZ core.
 
 

### Dependencies









### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cz.img-order.r4)](package.r4.tgz) and [R4B (hl7.fhir.cz.img-order.r4b)](package.r4b.tgz) are available.

### IP statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.3.0/CodeSystem-ISO3166Part1.html): [AttachmentImagingOrder2FHIRcz](ConceptMap-AttachmentImagingOrder2FHIR-cz.md), [BodyImagingOrder2FHIRcz](ConceptMap-BodyImagingOrder2FHIR-cz.md)...Show 71 more,[Bundle/BundleKralikRTG](Bundle-BundleKralikRTG.md),[CZ_Appointment](StructureDefinition-cz-appointment.md),[CZ_BodyHeight](StructureDefinition-cz-bodyheight.md),[CZ_BodyWeight](StructureDefinition-cz-bodyweight.md),[CZ_BundleImageOrder](StructureDefinition-cz-bundleImageOrder.md),[CZ_CarePlanImage](StructureDefinition-cz-carePlanImage.md),[CZ_CompositionImageOrder](StructureDefinition-cz-compositionImageOrder.md),[CZ_CompositionTypeVs](ValueSet-cz-composition-type-vs.md),[CZ_ConditionClinicalQuestion](StructureDefinition-cz-conditionClinicalQuestion.md),[CZ_ConditionImage](StructureDefinition-cz-conditionImage.md),[CZ_DeviceUseStatement](StructureDefinition-cz-deviceUseStatement.md),[CZ_DiagnosisConditionVs](ValueSet-cz-diagnosis-condition-vs.md),[CZ_Flag](StructureDefinition-cz-flag.md),[CZ_ImagingOrderInformation](StructureDefinition-cz-imagingOrderInformation.md),[CZ_ImagingProcedureVs](ValueSet-cz-imaging-procedure-vs.md),[CZ_MobilityTypeVs](ValueSet-cz-mobility-type.md),[CZ_MobilityValueVs](ValueSet-cz-mobility-value.md),[CZ_ModalityVs](ValueSet-cz-modality-vs.md),[CZ_ObservationImage](StructureDefinition-cz-observationImage.md),[CZ_ObservationUnitsHeightVs](ValueSet-cz-observationUnitsHeight-vs.md),[CZ_ObservationUnitsWeightVs](ValueSet-cz-observationUnitsWeight-vs.md),[CZ_PatientMobility](StructureDefinition-cz-potientMobility.md),[CZ_ProvisionCodeVs](ValueSet-cz-provision-code.md),[HL7CzImagingOrderImplementationGuide](index.md),[HeaderImagingOrder2FHIRcz](ConceptMap-HeaderImagingOrder2FHIR-cz.md),[LogCzAdditionalRecipient](StructureDefinition-logAdditionalRecipientCz.md),[LogCzAttachmentsCz](StructureDefinition-logAttachmentsCz.md),[LogCzAuthorOrderCz](StructureDefinition-logAuthorCz.md),[LogCzBodyImageOrderCz](StructureDefinition-logBodyImageOrderCz.md),[LogCzClinicalEventCz](StructureDefinition-logClinicalEventCz.md),[LogCzCoverageBodyCz](StructureDefinition-logCoverageBodyCz.md),[LogCzCoverageOrderCz](StructureDefinition-logCoverageOrderCz.md),[LogCzDigitalSignatureCz](StructureDefinition-logdigitalSignatureCz.md),[LogCzDocumentMetadataOrderCz](StructureDefinition-logDocumentMetadataCz.md),[LogCzHeaderImagingOrderCz](StructureDefinition-logHeaderImagingOrder.md),[LogCzImageAppointmentCz](StructureDefinition-logImageAppointmentCz.md),[LogCzImageOrderInformationCz](StructureDefinition-logImageOrderInformationCz.md),[LogCzImageSupportingInformationCz](StructureDefinition-logImageSupportingInformationCz.md),[LogCzImagingOrderCz](StructureDefinition-logImagingOrderCz.md),[LogCzOrderDataElementsCz](StructureDefinition-logOrderDataElementsCz.md),[LogCzOtherSupportingInformationCz](StructureDefinition-logOtherSupportingInformationCz.md),[LogCzPayerOrderCz](StructureDefinition-logPayerCz.md),[LogCzPlannedCareOrdersCz](StructureDefinition-logPlannedCareOrdersCz.md),[LogCzPresentedFormCz](StructureDefinition-logPresentedFormCz.md),[LogCzRequestedPerformerOrderCz](StructureDefinition-logRequestedPerformerCz.md),[LogCzSpecimenInformationCz](StructureDefinition-logSpecimenInformationCz.md),[LogCzSubjectImagingOrderCz](StructureDefinition-logSubjectCz.md),[LogEnAdditionalRecipient](StructureDefinition-AdditionalRecipientCz.md),[LogEnAttachmentsCz](StructureDefinition-AttachmentsCz.md),[LogEnAuthorOrderCz](StructureDefinition-AuthorCz.md),[LogEnBodyImageOrderCz](StructureDefinition-BodyImageOrderCz.md),[LogEnClinicalEventCz](StructureDefinition-ClinicalEventCz.md),[LogEnCoverageBodyCz](StructureDefinition-CoverageBodyCz.md),[LogEnCoverageOrderCz](StructureDefinition-CoverageOrderCz.md),[LogEnDigitalSignatureCz](StructureDefinition-digitalSignatureCz.md),[LogEnDocumentMetadataOrderCz](StructureDefinition-DocumentMetadataCz.md),[LogEnHeaderImagingOrderCz](StructureDefinition-HeaderImagingOrder.md),[LogEnImageAppointmentCz](StructureDefinition-ImageAppointmentCz.md),[LogEnImageOrderInformationCz](StructureDefinition-ImageOrderInformationCz.md),[LogEnImageSupportingInformationCz](StructureDefinition-ImageSupportingInformationCz.md),[LogEnImagingOrderCz](StructureDefinition-ImagingOrderCz.md),[LogEnOrderDataElementsCz](StructureDefinition-OrderDataElementsCz.md),[LogEnOtherSupportingInformationCz](StructureDefinition-OtherSupportingInformationCz.md),[LogEnPayerOrderCz](StructureDefinition-PayerCz.md),[LogEnPlannedCareOrdersCz](StructureDefinition-PlannedCareOrdersCz.md),[LogEnPresentedFormCz](StructureDefinition-PresentedFormCz.md),[LogEnRequestedPerformerOrderCz](StructureDefinition-RequestedPerformerCz.md),[LogEnSpecimenInformationCz](StructureDefinition-SpecimenInformationCz.md),[LogEnSubjectImagingOrderCz](StructureDefinition-SubjectCz.md),[Patient/Mracena](Patient-Mracena.md)and[Patient/dd800c46-f71a-4628-b457-6ccaa27dd6bc](Patient-dd800c46-f71a-4628-b457-6ccaa27dd6bc.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.3.0/CodeSystem-v3-ucum.html): [Bundle/BundleKralikRTG](Bundle-BundleKralikRTG.md), [CZ_BodyHeight](StructureDefinition-cz-bodyheight.md)...Show 7 more,[CZ_BodyWeight](StructureDefinition-cz-bodyweight.md),[CZ_ObservationUnitsHeightVs](ValueSet-cz-observationUnitsHeight-vs.md),[CZ_ObservationUnitsWeightVs](ValueSet-cz-observationUnitsWeight-vs.md),[Observation/4a38a57a-fdfe-48df-802c-8d7e8e3e1a3b](Observation-4a38a57a-fdfe-48df-802c-8d7e8e3e1a3b.md),[Observation/ExampleBodyHeight](Observation-ExampleBodyHeight.md),[Observation/ExampleBodyWeight](Observation-ExampleBodyWeight.md)and[Observation/e0861d9f-4b04-465f-b15b-cb01e3a8b677](Observation-e0861d9f-4b04-465f-b15b-cb01e3a8b677.md)


* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright Â© 2011 by the National Electrical Manufacturers Association.

* DICOM Controlled Terminology Definitions: [Bundle/BundleKralikRTG](Bundle-BundleKralikRTG.md), [CZ_ImagingOrderInformation](StructureDefinition-cz-imagingOrderInformation.md)...Show 8 more,[CZ_ModalityVs](ValueSet-cz-modality-vs.md),[ServiceRequest/158808ba-fcca-480e-8188-dec77920ec3c](ServiceRequest-158808ba-fcca-480e-8188-dec77920ec3c.md),[ServiceRequest/210db397-977a-47a0-8a2e-febde6f9f92a](ServiceRequest-210db397-977a-47a0-8a2e-febde6f9f92a.md),[ServiceRequest/5ab3e344-4d0c-4786-bab2-7dd0d7b60cd9](ServiceRequest-5ab3e344-4d0c-4786-bab2-7dd0d7b60cd9.md),[ServiceRequest/c8d7d3d8-9007-45a7-8f09-0ae69f7d7fed](ServiceRequest-c8d7d3d8-9007-45a7-8f09-0ae69f7d7fed.md),[ServiceRequest/d6784779-d008-447d-90cf-89d5d53a0f04](ServiceRequest-d6784779-d008-447d-90cf-89d5d53a0f04.md),[ServiceRequest/ded5bee9-8a58-4676-919f-0b8e08eaede4](ServiceRequest-ded5bee9-8a58-4676-919f-0b8e08eaede4.md)and[ServiceRequest/fea1dbb8-9e16-4e11-beae-c12829c97381](ServiceRequest-fea1dbb8-9e16-4e11-beae-c12829c97381.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.3.0/CodeSystem-v3-loinc.html): [Bundle/BundleKralikRTG](Bundle-BundleKralikRTG.md), [CZ_BodyHeight](StructureDefinition-cz-bodyheight.md)...Show 7 more,[CZ_BodyWeight](StructureDefinition-cz-bodyweight.md),[CZ_CompositionImageOrder](StructureDefinition-cz-compositionImageOrder.md),[Composition/dbd426a9-d660-4f97-8656-1e39db4a57c9](Composition-dbd426a9-d660-4f97-8656-1e39db4a57c9.md),[Observation/4a38a57a-fdfe-48df-802c-8d7e8e3e1a3b](Observation-4a38a57a-fdfe-48df-802c-8d7e8e3e1a3b.md),[Observation/ExampleBodyHeight](Observation-ExampleBodyHeight.md),[Observation/ExampleBodyWeight](Observation-ExampleBodyWeight.md)and[Observation/e0861d9f-4b04-465f-b15b-cb01e3a8b677](Observation-e0861d9f-4b04-465f-b15b-cb01e3a8b677.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [Bundle/BundleKralikRTG](Bundle-BundleKralikRTG.md), [CZ_CompositionImageOrder](StructureDefinition-cz-compositionImageOrder.md)...Show 27 more,[CZ_CompositionTypeVs](ValueSet-cz-composition-type-vs.md),[CZ_ConditionClinicalQuestion](StructureDefinition-cz-conditionClinicalQuestion.md),[CZ_ConditionImage](StructureDefinition-cz-conditionImage.md),[CZ_DeviceUseStatement](StructureDefinition-cz-deviceUseStatement.md),[CZ_ImagingOrderInformation](StructureDefinition-cz-imagingOrderInformation.md),[CZ_ImagingProcedureVs](ValueSet-cz-imaging-procedure-vs.md),[CZ_MobilityTypeVs](ValueSet-cz-mobility-type.md),[CZ_MobilityValueVs](ValueSet-cz-mobility-value.md),[CZ_PatientMobility](StructureDefinition-cz-potientMobility.md),[Device/711e1d43-d5e4-4cbc-b546-74059db270f6](Device-711e1d43-d5e4-4cbc-b546-74059db270f6.md),[Device/MRDevice](Device-MRDevice.md),[Device/e33c93c6-3dd0-4595-9f15-63b9302861d1](Device-e33c93c6-3dd0-4595-9f15-63b9302861d1.md),[DeviceUseStatement/b29cacfd-b05b-44cf-be5a-8b6d76bdc375](DeviceUseStatement-b29cacfd-b05b-44cf-be5a-8b6d76bdc375.md),[Observation/4a38a57a-fdfe-48df-802c-8d7e8e3e1a3b](Observation-4a38a57a-fdfe-48df-802c-8d7e8e3e1a3b.md),[Observation/ExampleBodyHeight](Observation-ExampleBodyHeight.md),[Observation/ExampleBodyWeight](Observation-ExampleBodyWeight.md),[Observation/d70a725d-baa9-4553-a670-2609b0c0219f](Observation-d70a725d-baa9-4553-a670-2609b0c0219f.md),[Observation/e0861d9f-4b04-465f-b15b-cb01e3a8b677](Observation-e0861d9f-4b04-465f-b15b-cb01e3a8b677.md),[PractitionerRole/f0ac1e16-61f5-4591-a7eb-1dc586e25349](PractitionerRole-f0ac1e16-61f5-4591-a7eb-1dc586e25349.md),[ServiceRequest/158808ba-fcca-480e-8188-dec77920ec3c](ServiceRequest-158808ba-fcca-480e-8188-dec77920ec3c.md),[ServiceRequest/210db397-977a-47a0-8a2e-febde6f9f92a](ServiceRequest-210db397-977a-47a0-8a2e-febde6f9f92a.md),[ServiceRequest/5ab3e344-4d0c-4786-bab2-7dd0d7b60cd9](ServiceRequest-5ab3e344-4d0c-4786-bab2-7dd0d7b60cd9.md),[ServiceRequest/c8d7d3d8-9007-45a7-8f09-0ae69f7d7fed](ServiceRequest-c8d7d3d8-9007-45a7-8f09-0ae69f7d7fed.md),[ServiceRequest/cz-imagingorder-example](ServiceRequest-cz-imagingorder-example.md),[ServiceRequest/d6784779-d008-447d-90cf-89d5d53a0f04](ServiceRequest-d6784779-d008-447d-90cf-89d5d53a0f04.md),[ServiceRequest/ded5bee9-8a58-4676-919f-0b8e08eaede4](ServiceRequest-ded5bee9-8a58-4676-919f-0b8e08eaede4.md)and[ServiceRequest/fea1dbb8-9e16-4e11-beae-c12829c97381](ServiceRequest-fea1dbb8-9e16-4e11-beae-c12829c97381.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Condition Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-condition-category.html): [CZ_ConditionImage](StructureDefinition-cz-conditionImage.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html): [Bundle/BundleKralikRTG](Bundle-BundleKralikRTG.md), [Observation/4a38a57a-fdfe-48df-802c-8d7e8e3e1a3b](Observation-4a38a57a-fdfe-48df-802c-8d7e8e3e1a3b.md), [Observation/ExampleBodyHeight](Observation-ExampleBodyHeight.md), [Observation/ExampleBodyWeight](Observation-ExampleBodyWeight.md) and [Observation/e0861d9f-4b04-465f-b15b-cb01e3a8b677](Observation-e0861d9f-4b04-465f-b15b-cb01e3a8b677.md)
* [ActCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html): [Bundle/BundleKralikRTG](Bundle-BundleKralikRTG.md) and [Encounter/db16a37b-d393-4767-bb2e-739f9bff16f9](Encounter-db16a37b-d393-4767-bb2e-739f9bff16f9.md)




## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.cz.img-order",
  "language" : "cs",
  "url" : "https://hl7.cz/fhir/img-order/ImplementationGuide/hl7.fhir.cz.img-order",
  "version" : "0.1.0-ballot",
  "name" : "HL7CzImagingOrderImplementationGuide",
  "title" : "HL7 Czech Imaging Order IG",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "HL7 Czech Imaging Order Implementation Guide",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.cz.img-order",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_cz_core",
      "uri" : "https://hl7.cz/fhir/core/ImplementationGuide/hl7.fhir.cz.core",
      "packageId" : "hl7.fhir.cz.core",
      "version" : "current"
    },
    {
      "id" : "hl7_fhir_eu_base",
      "uri" : "http://hl7.eu/fhir/base/ImplementationGuide/hl7.fhir.eu.base",
      "packageId" : "hl7.fhir.eu.base",
      "version" : "0.1.0-ballot"
    },
    {
      "id" : "hl7_fhir_eu_extensions",
      "uri" : "http://hl7.eu/fhir/extensions/ImplementationGuide/hl7.fhir.eu.extensions",
      "packageId" : "hl7.fhir.eu.extensions",
      "version" : "0.1.1-ballot"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ballot"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../expansion-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.cz/fhir/img-order/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/expansion-parameters",
        "valueReference" : {
          "reference" : "Parameters/expansion-parameters"
        }
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ballot"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../expansion-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.cz/fhir/img-order/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "czech-logical-model",
        "name" : "Czech logical model (Informative)",
        "description" : "Logical model in czech language. Informative for this version of the guide."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ImagingOrderCz"
        },
        "name" : "A - Imaging Order",
        "description" : "Imaging Order",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logImagingOrderCz"
        },
        "name" : "A - Žádanka obrazového vyšetření",
        "description" : "Žádanka obrazového vyšetření",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logHeaderImagingOrder"
        },
        "name" : "A.1 - Hlavička dokumentu",
        "description" : "Záhlaví dokumentu s administrativními údaji",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HeaderImagingOrder"
        },
        "name" : "A.1 - Imaging Order header data element",
        "description" : "Imaging Order - Imaging Order header data element - A.1",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SubjectCz"
        },
        "name" : "A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject",
        "description" : "Imaging Order - Imaging Order subject data element - A.1.1 and A.1.2",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logSubjectCz"
        },
        "name" : "A.1.1 - Identifikace a A.1.2 - Kontaktní informace Pacienta/subjektu",
        "description" : "Identifikace pacienta a kontaktní informace pacienta",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PayerCz"
        },
        "name" : "A.1.3 - Health insurance and payment information",
        "description" : "Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logPayerCz"
        },
        "name" : "A.1.3 - Zdravotní pojištění",
        "description" : "Informace o zdravotním pojištění.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CoverageOrderCz"
        },
        "name" : "A.1.4 - Information about coverage",
        "description" : "Coverage information - Information about method of coverage, payer identification data and additional information",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logCoverageOrderCz"
        },
        "name" : "A.1.4 - Úhrada",
        "description" : "Informace o způsobu úhrady objednávky vyšetření",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AuthorCz"
        },
        "name" : "A.1.5 - Author",
        "description" : "Author (by whom the Imaging order was/were authored). Multiple authors could be provided.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logAuthorCz"
        },
        "name" : "A.1.5 - Objednatel",
        "description" : "Objednatel (Objednatel provedení zdravotní služby).",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/RequestedPerformerCz"
        },
        "name" : "A.1.6 - Requested Performer (processing person)",
        "description" : "Person who is requested to process document.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logRequestedPerformerCz"
        },
        "name" : "A.1.6 - Zpracovatel",
        "description" : "Předpokládaný zpracovatel žádanky (u neadresné žádanky nebude zpracovatel uveden).",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AdditionalRecipientCz"
        },
        "name" : "A.1.7 - Additional Recipient",
        "description" : "Additional Recipient (Additional recipients of the finding in addition to the author)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logAdditionalRecipientCz"
        },
        "name" : "A.1.7 - Příjemce nálezu",
        "description" : "Příjemce nálezu (Dodateční příjemci nálezu kromě objednatele)",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DocumentMetadataCz"
        },
        "name" : "A.1.8 - Document metadata",
        "description" : "Document metadata",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logDocumentMetadataCz"
        },
        "name" : "A.1.8 - Metadata dokumentu",
        "description" : "Metadata dokumentu",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/digitalSignatureCz"
        },
        "name" : "A.1.9 - Digital signature",
        "description" : "Digital signature - Electronic signature or seal of a document according to Act 327/2011 §54a",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logdigitalSignatureCz"
        },
        "name" : "A.1.9 - Elektronické podpisy",
        "description" : "Elektronické podpisy - Elektronické podpisy nebo pečetě dle zákona 327/2011 §54a",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logBodyImageOrderCz"
        },
        "name" : "A.2 a A.3 - Tělo dokumentu",
        "description" : "Tělo dokumentu",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BodyImageOrderCz"
        },
        "name" : "A.2 and A.3 - Body Imaging Order",
        "description" : "Body Imaging Order",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logImageOrderInformationCz"
        },
        "name" : "A.2.1 - Informace o objednávce and A.2.2 - Odůvodnění vyšetření (důvod objednávky)",
        "description" : "Informace o objednávce a Odůvodnění vyšetření (důvod objednávky)",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ImageOrderInformationCz"
        },
        "name" : "A.2.1 - Order information and A.2.2 - Order reason",
        "description" : "Information about order and order reason",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ClinicalEventCz"
        },
        "name" : "A.2.3 - Clinical event (Encounter)",
        "description" : "Clinical event (Encounter) - Information about the clinical event to which the order relates",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logClinicalEventCz"
        },
        "name" : "A.2.3 - Klinická událost (encounter)",
        "description" : "Informace o klinické události, ke které se objednávka vztahuje (odkaz na návštěvu)",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CoverageBodyCz"
        },
        "name" : "A.2.4 - Information about additional coverage",
        "description" : "Additional coverage information - Information about method of coverage, payer identification data and additional information",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logCoverageBodyCz"
        },
        "name" : "A.2.4 - Úhrada",
        "description" : "Informace o způsobu úhrady objednávky vyšetření",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ImageAppointmentCz"
        },
        "name" : "A.2.5 - Appointment",
        "description" : "Appointment - Links to planned care order related to this request form",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logImageAppointmentCz"
        },
        "name" : "A.2.5 - Termín návštěvy",
        "description" : "Informace o objednaném termínu vyšetření (pokud byl termín rezervován)",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logSpecimenInformationCz"
        },
        "name" : "A.2.6 - Informace o vzorku",
        "description" : "Pro specifická obrazová vyšetření vzorku",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SpecimenInformationCz"
        },
        "name" : "A.2.6 - Specimen Information",
        "description" : "Information about specimen",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logImageSupportingInformationCz"
        },
        "name" : "A.3.1 - Klinické informace",
        "description" : "Informace a údaje sdělované pracovišti zobrazovacích metod, mající vliv na provedení objednávky či interpretaci výsledků vyšetření",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ImageSupportingInformationCz"
        },
        "name" : "A.3.1 - Supporting Information",
        "description" : "Supporting Information - Information and data communicated by the imaging methods department that has an impact on the execution of the order or the interpretation of the examination results",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logOrderDataElementsCz"
        },
        "name" : "A.3.2 - Datové elementy objednávky / vyšetření",
        "description" : "Datové elementy objednávky / vyšetření",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/OrderDataElementsCz"
        },
        "name" : "A.3.2 - Order Data Elements",
        "description" : "Order Data Elements - Order/examination data elements",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logPlannedCareOrdersCz"
        },
        "name" : "A.3.3 - Objednávky plánované péče",
        "description" : "Odkazy na objednávky plánované péče navazující na tuto žádanku",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PlannedCareOrdersCz"
        },
        "name" : "A.3.3 - Planned Care Orders",
        "description" : "Planned Care Orders - Links to planned care orders related to this request form",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logOtherSupportingInformationCz"
        },
        "name" : "A.3.4 - Další podpůrné informace",
        "description" : "Ostatní podpůrné informace",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/OtherSupportingInformationCz"
        },
        "name" : "A.3.4 - Other Supporting Information",
        "description" : "Other Supporting Information - Links to other supporting information related to this request form",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PresentedFormCz"
        },
        "name" : "A.4 - Presented form",
        "description" : "Presented form - Entire order as issued. Various formats could be provided,  pdf format is recommended.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logPresentedFormCz"
        },
        "name" : "A.4 - Vizuální podoba dokumentu",
        "description" : "Žádanka obrazového vyšetření čitelná lidským okem,  je požadován PDF formát.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AttachmentsCz"
        },
        "name" : "A.5 - Attachments",
        "description" : "Additional attachments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logAttachmentsCz"
        },
        "name" : "A.5 - Přílohy",
        "description" : "Ostatní přílohy.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-appointment"
        },
        "name" : "Appointment: Imaging Order (CZ)",
        "description" : "Czech profile for appointment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Appointment"
          }
        ],
        "reference" : {
          "reference" : "Appointment/AppointmentExample"
        },
        "name" : "AppointmentExample",
        "description" : "Appointment",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-appointment"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ExampleBodyHeight"
        },
        "name" : "Body height of patient",
        "description" : "Example of body height of Patient Mracena",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bodyheight"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/4a38a57a-fdfe-48df-802c-8d7e8e3e1a3b"
        },
        "name" : "Body height of patient Kralik",
        "description" : "Example of body height of Patient Kralik",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bodyheight"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-bodyheight"
        },
        "name" : "Body Height: Imaging Order (CZ)",
        "description" : "Profile of body height for the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ExampleBodyWeight"
        },
        "name" : "Body weight of patient",
        "description" : "Example of body weight of Patient Mracena",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bodyweight"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/e0861d9f-4b04-465f-b15b-cb01e3a8b677"
        },
        "name" : "Body weight of patient Kralik",
        "description" : "Example of body weight of Patient Kralik",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bodyweight"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-bodyweight"
        },
        "name" : "Body Weight: Imaging Order (CZ)",
        "description" : "Profile of body weight for the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-bundleImageOrder"
        },
        "name" : "Bundle: Imaging Order (CZ)",
        "description" : "Clinical document used to represent a Imaging Order for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/BundleKralikRTG"
        },
        "name" : "Bundle: RTG Patient Kralik",
        "description" : "Example of Imaging order (Bundle) including a RTG order",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bundleImageOrder"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-carePlanImage"
        },
        "name" : "Care plan: Imaging Order (CZ)",
        "description" : "Care plan for Imaging Order for the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CarePlan"
          }
        ],
        "reference" : {
          "reference" : "CarePlan/CarePlanExample"
        },
        "name" : "CarePlanExample",
        "description" : "Care Plan",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-carePlanImage"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-compositionImageOrder"
        },
        "name" : "Composition: Imaging Order (CZ)",
        "description" : "Clinical document used to represent a Imaging Order for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-conditionClinicalQuestion"
        },
        "name" : "Condition: Clinical question (CZ)",
        "description" : "Condition for purpose of clinical question in Imaging Order for the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-conditionImage"
        },
        "name" : "Condition: Imaging Order (CZ)",
        "description" : "Condition for Imaging Order for the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Coverage"
          }
        ],
        "reference" : {
          "reference" : "Coverage/92fcdc96-95c0-4cc9-9857-afee3bed913c"
        },
        "name" : "Coverage - Healthcare insurance company",
        "description" : "Example of coverage",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/AttachmentImagingOrder2FHIR-cz"
        },
        "name" : "CZ Attachment Model to this guide Map",
        "description" : "CZ Imaging Order Attachment Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/BodyImagingOrder2FHIR-cz"
        },
        "name" : "CZ Body Model to this guide Map",
        "description" : "CZ Imaging Order Body Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-composition-type-vs"
        },
        "name" : "CZ Composition Type",
        "description" : "This value set includes all imaging composition types.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-diagnosis-condition-vs"
        },
        "name" : "CZ Diagnosis Condition",
        "description" : "ValueSet for diagnosis in condition in the Czech Imaging project, using MKN-10 and ORPHA codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/HeaderImagingOrder2FHIR-cz"
        },
        "name" : "CZ Header Model to this guide Map",
        "description" : "CZ Imaging Order Header Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-imaging-procedure-vs"
        },
        "name" : "CZ Imaging Procedure",
        "description" : "ValueSet for imaging procedure in the Czech Imaging project, using SNOMED CT.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-mobility-type"
        },
        "name" : "CZ Mobility Type",
        "description" : "This value set includes all patient mobility types for imaging order.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-mobility-value"
        },
        "name" : "CZ Mobility Value",
        "description" : "This value set includes all patient im/mobility values for imaging order.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-modality-vs"
        },
        "name" : "CZ Modality",
        "description" : "This value set includes all modalities.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-provision-code"
        },
        "name" : "CZ Provision Code",
        "description" : "ValueSet for provision codes in the Czech Imaging project, using Orphacode.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/db16a37b-d393-4767-bb2e-739f9bff16f9"
        },
        "name" : "cz-encounter-example",
        "description" : "Encounter",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/cz-imagingorder-example"
        },
        "name" : "cz-imagingorder-example",
        "description" : "Imaging order for Magnetic Resonance",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-imagingOrderInformation"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/5bdedd9b-27c5-4593-ae3a-968c5f25d253"
        },
        "name" : "cz-organizationwithlogo-example",
        "description" : "An example of the organization with logo extension",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/16793b99-aecc-482d-8283-0e4885e0ca25"
        },
        "name" : "cz-practitioner1-example",
        "description" : "Example of practitioner",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/984dcf34-1924-45a8-8ec5-3d100b67d9be"
        },
        "name" : "cz-practitioner2-example",
        "description" : "Example of practitioner",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-deviceUseStatement"
        },
        "name" : "Device Use Statement: Imaging Order (CZ)",
        "description" : "This profile represents the constraints applied to the DeviceUseStatement resource for the purpose of this guide. A device used by or implanted on the patient is described in the imaging order as an instance of a Device resource constrained by this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/711e1d43-d5e4-4cbc-b546-74059db270f6"
        },
        "name" : "Example Device - Implantable Pacemaker",
        "description" : "A sample Device resource for an implantable pacemaker, referenced in a DeviceUseStatement.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DeviceUseStatement"
          }
        ],
        "reference" : {
          "reference" : "DeviceUseStatement/b29cacfd-b05b-44cf-be5a-8b6d76bdc375"
        },
        "name" : "Example DeviceUseStatement for Implant",
        "description" : "A DeviceUseStatement documenting the use of an implanted pacemaker in the imaging order.",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-deviceUseStatement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/expansion"
        },
        "name" : "expansion",
        "description" : "SNOMED CT Czech expansion parameter",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-flag"
        },
        "name" : "Flag: Imaging Order (CZ)",
        "description" : "Czech profile for flag.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/dbd426a9-d660-4f97-8656-1e39db4a57c9"
        },
        "name" : "Imaging Order - Rentgen Ing. Králíka",
        "description" : "Example of Imaging order (Composition) including a RTG order",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-compositionImageOrder"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/d6784779-d008-447d-90cf-89d5d53a0f04"
        },
        "name" : "Imaging order for Plain X-ray",
        "description" : "Imaging order for Plain X-ray",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-imagingOrderInformation"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/fea1dbb8-9e16-4e11-beae-c12829c97381"
        },
        "name" : "Imaging order for Plain X-ray",
        "description" : "Imaging order for Plain X-ray",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-imagingOrderInformation"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/210db397-977a-47a0-8a2e-febde6f9f92a"
        },
        "name" : "Imaging order for Plain X-ray",
        "description" : "Imaging order for Plain X-ray",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-imagingOrderInformation"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/ded5bee9-8a58-4676-919f-0b8e08eaede4"
        },
        "name" : "Imaging order for Plain X-ray",
        "description" : "Imaging order for Plain X-ray",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-imagingOrderInformation"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/158808ba-fcca-480e-8188-dec77920ec3c"
        },
        "name" : "Imaging order for Plain X-ray",
        "description" : "Imaging order for Plain X-ray",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-imagingOrderInformation"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/5ab3e344-4d0c-4786-bab2-7dd0d7b60cd9"
        },
        "name" : "Imaging order for Plain X-ray",
        "description" : "Imaging order for Plain X-ray",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-imagingOrderInformation"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/c8d7d3d8-9007-45a7-8f09-0ae69f7d7fed"
        },
        "name" : "Imaging order for Plain X-ray",
        "description" : "Imaging order for Plain X-ray",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-imagingOrderInformation"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/LocationExample"
        },
        "name" : "LocationExample",
        "description" : "Example of location",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/0af43461-495e-4dfc-82ca-7f3140a60fe7"
        },
        "name" : "logoFNOblackov-example",
        "description" : "Example of logo as document reference for FN Obláčkov.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/Mracena"
        },
        "name" : "Mracena",
        "description" : "Patient, contact information and practitioner",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/MRDevice"
        },
        "name" : "MRDevice",
        "description" : "Magnetic Resonance device",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observationImage"
        },
        "name" : "Observation: Imaging Order (CZ)",
        "description" : "Observation for Imaging Order for the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-observationUnitsHeight-vs"
        },
        "name" : "ObservationsUnitHeight",
        "description" : "UCUM units for height",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-observationUnitsWeight-vs"
        },
        "name" : "ObservationsUnitWeight",
        "description" : "UCUM units for weight",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/35e78cc9-6fe2-42a8-8553-83a3f86ce308"
        },
        "name" : "Organization - Healthcare insurance company",
        "description" : "Example of insurance organisation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/dd800c46-f71a-4628-b457-6ccaa27dd6bc"
        },
        "name" : "Patient Kralik",
        "description" : "Patient, contact information",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/d70a725d-baa9-4553-a670-2609b0c0219f"
        },
        "name" : "Patient mobility of patient Kralik",
        "description" : "Example of patient mobility of Patient Kralik",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-potientMobility"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-potientMobility"
        },
        "name" : "Patient mobility: Imaging Order (CZ)",
        "description" : "Profile of patient mobility observation for the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/f0ac1e16-61f5-4591-a7eb-1dc586e25349"
        },
        "name" : "Practitioner Role Radiology",
        "description" : "Author of RTG Imaging report",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/practitionerExample"
        },
        "name" : "practitionerExample",
        "description" : "Example of practitioner",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/8ca719d9-da84-4bc0-a7da-860eac1347ce"
        },
        "name" : "Reason in code form",
        "description" : "Condition",
        "exampleCanonical" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-conditionImage"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/e33c93c6-3dd0-4595-9f15-63b9302861d1"
        },
        "name" : "RGDevice",
        "description" : "Radiographic imaging device",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-imagingOrderInformation"
        },
        "name" : "Service Request: Imaging Order (CZ)",
        "description" : "Order information for the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index-cs.html"
            }
          ],
          "nameUrl" : "index-cs.html",
          "title" : "Domovská stránka",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "scope-and-content.html"
            }
          ],
          "nameUrl" : "scope-and-content.html",
          "title" : "Scope and content",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "scope-and-content-cs.html"
            }
          ],
          "nameUrl" : "scope-and-content-cs.html",
          "title" : "Oblasti a obsah",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "background.html"
            }
          ],
          "nameUrl" : "background.html",
          "title" : "Background",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "background-cs.html"
            }
          ],
          "nameUrl" : "background-cs.html",
          "title" : "Background",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors.html"
            }
          ],
          "nameUrl" : "authors.html",
          "title" : "Authors",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors-cs.html"
            }
          ],
          "nameUrl" : "authors-cs.html",
          "title" : "Autoři",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright.html"
            }
          ],
          "nameUrl" : "copyright.html",
          "title" : "Copyright",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright-cs.html"
            }
          ],
          "nameUrl" : "copyright-cs.html",
          "title" : "Autorská práva",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies.html"
            }
          ],
          "nameUrl" : "dependencies.html",
          "title" : "Dependencies",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies-cs.html"
            }
          ],
          "nameUrl" : "dependencies-cs.html",
          "title" : "Závislosti",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples-cs.html"
            }
          ],
          "nameUrl" : "examples-cs.html",
          "title" : "Příklady",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "logical-models.html"
            }
          ],
          "nameUrl" : "logical-models.html",
          "title" : "Logical models",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "logical-models-cs.html"
            }
          ],
          "nameUrl" : "logical-models-cs.html",
          "title" : "Datová sada - logické modely",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "model-map.html"
            }
          ],
          "nameUrl" : "model-map.html",
          "title" : "Model maps",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "model-map-cs.html"
            }
          ],
          "nameUrl" : "model-map-cs.html",
          "title" : "Mapování logického modelu",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "obligations.html"
            }
          ],
          "nameUrl" : "obligations.html",
          "title" : "Obligations",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "obligations-cs.html"
            }
          ],
          "nameUrl" : "obligations-cs.html",
          "title" : "Obligations",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "terminology-considerations.html"
            }
          ],
          "nameUrl" : "terminology-considerations.html",
          "title" : "Terminology considerations",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "terminology-considerations-cs.html"
            }
          ],
          "nameUrl" : "terminology-considerations-cs.html",
          "title" : "Terminologické aspekty",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "use-cases.html"
            }
          ],
          "nameUrl" : "use-cases.html",
          "title" : "Use cases",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "use-cases-cs.html"
            }
          ],
          "nameUrl" : "use-cases-cs.html",
          "title" : "Příklady užití",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "workflow.html"
            }
          ],
          "nameUrl" : "workflow.html",
          "title" : "Workflow",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "workflow-cs.html"
            }
          ],
          "nameUrl" : "workflow-cs.html",
          "title" : "Workflow",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artifacts.html"
            }
          ],
          "nameUrl" : "artifacts.html",
          "title" : "Artifacts",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Download",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads-cs.html"
            }
          ],
          "nameUrl" : "downloads-cs.html",
          "title" : "Download",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "implementation-notes.html"
            }
          ],
          "nameUrl" : "implementation-notes.html",
          "title" : "Implementation notes",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "implementation-notes-cs.html"
            }
          ],
          "nameUrl" : "implementation-notes-cs.html",
          "title" : "Poznámky k implementaci",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "Header-map.html"
            }
          ],
          "nameUrl" : "Header-map.html",
          "title" : "Header Model map",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "Header-map-cs.html"
            }
          ],
          "nameUrl" : "Header-map-cs.html",
          "title" : "Mapování logického modelu hlavičky",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "Body-map.html"
            }
          ],
          "nameUrl" : "Body-map.html",
          "title" : "Body Model map",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "Body-map-cs.html"
            }
          ],
          "nameUrl" : "Body-map-cs.html",
          "title" : "Mapování logického modelu těla",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "Attachment-map.html"
            }
          ],
          "nameUrl" : "Attachment-map.html",
          "title" : "Presented Form and Attachment Model map",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "Attachment-map-cs.html"
            }
          ],
          "nameUrl" : "Attachment-map-cs.html",
          "title" : "Mapování logického modelu vizuální podoby dokumentu a příloh",
          "generation" : "html"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
