# CZ Mobility Type - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Mobility Type**

## ValueSet: CZ Mobility Type 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/ValueSet/cz-mobility-type | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:CZ_MobilityTypeVs |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
This value set includes all patient mobility types for imaging order. 

 **References** 

* [Patient mobility: Imaging Order (CZ)](StructureDefinition-cz-potientMobility.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-mobility-type",
  "url" : "https://hl7.cz/fhir/img-order/ValueSet/cz-mobility-type",
  "version" : "0.1.0-ballot",
  "name" : "CZ_MobilityTypeVs",
  "title" : "CZ Mobility Type",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This value set includes all patient mobility types for imaging order.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "710828008",
            "display" : "Assessment of ability to walk"
          },
          {
            "code" : "282870005",
            "display" : "Ability to stand up"
          },
          {
            "code" : "282970009",
            "display" : "Ability to stand"
          },
          {
            "code" : "301680009",
            "display" : "Ability to move in bed"
          }
        ]
      }
    ]
  }
}

```
