# A.2.6 - Informace o vzorku - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.6 - Informace o vzorku**

## Logical Model: A.2.6 - Informace o vzorku 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logSpecimenInformationCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzSpecimenInformationCz |

 
Pro specifická obrazová vyšetření vzorku 

**Usages:**

* Use this Logical Model: [A.2 a A.3 - Tělo dokumentu](StructureDefinition-logBodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logSpecimenInformationCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logSpecimenInformationCz.csv), [Excel](StructureDefinition-logSpecimenInformationCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logSpecimenInformationCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logSpecimenInformationCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzSpecimenInformationCz",
  "title" : "A.2.6 - Informace o vzorku",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Pro specifická obrazová vyšetření vzorku",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logSpecimenInformationCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logSpecimenInformationCz",
        "path" : "logSpecimenInformationCz",
        "short" : "A.2.6 - Informace o vzorku",
        "definition" : "Pro specifická obrazová vyšetření vzorku"
      },
      {
        "id" : "logSpecimenInformationCz.id",
        "path" : "logSpecimenInformationCz.id",
        "short" : "A.2.6.1 - ID vzorku",
        "definition" : "Identifikátor vzorku, který je jedinečný v rozsahu zvoleného rámce. Například: identifikátor přidělený objednávkovým systémem, identifikátor přidělený laboratoří apod. Možné je použití více identifikátorů.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.biologickyDruh",
        "path" : "logSpecimenInformationCz.biologickyDruh",
        "short" : "A.2.6.2 - Biologický druh",
        "definition" : "Biologický druh - týká se vzorků odebraných nikoliv přímo pacientovi, ale subjektu s pacientem souvisejícím. \n- Preferovaný systém: SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.material",
        "path" : "logSpecimenInformationCz.material",
        "short" : "A.2.6.3 - Materiál",
        "definition" : "Materiál vzorku.. \n- Preferovaný systém: SNOMED CT\n- Preferovaný systém: NCLPMAT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.datumACasSberu",
        "path" : "logSpecimenInformationCz.datumACasSberu",
        "short" : "A.2.6.4 - Datum a čas odběru, nebo čas ukončení  sběru a doba sběru",
        "definition" : "Datum a čas odběru, nebo čas ukončení  sběru a doba sběru materiálu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.datumACasTransportu",
        "path" : "logSpecimenInformationCz.datumACasTransportu",
        "short" : "A.2.6.5 - Datum a čas zahájení transportu vzorku do laboratoře",
        "definition" : "Datum a čas zahájení transportu vzorku do laboratoře.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.typ",
        "path" : "logSpecimenInformationCz.typ",
        "short" : "A.2.6.6 - Typ vzorku.",
        "definition" : "Entity odebrané za účelem vyšetření.\n- Preferovaný systém: SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.anatomickeUmisteni",
        "path" : "logSpecimenInformationCz.anatomickeUmisteni",
        "short" : "A.2.6.7 - Anatomické umístění",
        "definition" : "Anatomické umístění (umístění v rámci těla, lateralita) odkud je materiál odebrán, například 'levý loket'. \n- Preferovaný systém: SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.morfologie",
        "path" : "logSpecimenInformationCz.morfologie",
        "short" : "A.2.6.8 - Morfologie",
        "definition" : "Morfologické abnormality anatomického umístění odkud je materiál odebrán, například rána nebo vřed. \n- Preferovaný systém: SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.zarizeni",
        "path" : "logSpecimenInformationCz.zarizeni",
        "short" : "A.2.6.9 - Zařízení",
        "definition" : "V případě, že není materiál odebrán přímo z pacienta, ale pochází z předmětu, který s pacientem souvisí (například katetr).\n- Preferovaný systém: SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.procedura",
        "path" : "logSpecimenInformationCz.procedura",
        "short" : "A.2.6.10 - Procedura sběru",
        "definition" : "Sampling procedure - for cases where it is relevant to the results.\n- Preferovaný systém: SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.zdroj",
        "path" : "logSpecimenInformationCz.zdroj",
        "short" : "A.2.6.11 - Zdroj materiálu",
        "definition" : "If the material is not collected directly from the patient but comes from a patient-related object, e.g. a catheter\n - Preferovaný systém: SNOMED CT\n - Preferovaný systém: EMDN",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.odberoveMisto",
        "path" : "logSpecimenInformationCz.odberoveMisto",
        "short" : "A.2.6.12 - Odběrové místo",
        "definition" : "Prostor, kde byl realizován odběr materiálu; týká se prostředí, ne pacienta.\n - Preferovaný systém: SNOMED CT (environment)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.poznamka",
        "path" : "logSpecimenInformationCz.poznamka",
        "short" : "A.2.6.13 - Poznámka",
        "definition" : "Poznámka k materiálu volným textem",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.kontejner",
        "path" : "logSpecimenInformationCz.kontejner",
        "short" : "A.2.6.14 - Kontejner",
        "definition" : "A.2.6.14 - Kontejner",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.kontejner.typ",
        "path" : "logSpecimenInformationCz.kontejner.typ",
        "short" : "A.2.6.14.1 - Typ",
        "definition" : "Typ kontejneru pro odběr vzorku - zkumavka, odběrový vak atp. včetně chemických aditiv.\n - Preferovaný systém: SNOMED CT\n - Preferovaný systém: NCLPONP",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.kontejner.pocet",
        "path" : "logSpecimenInformationCz.kontejner.pocet",
        "short" : "A.2.6.14.2 - Počet",
        "definition" : "Počet kontejnerů s jedním stejným vzorkem (např. v případě, že se objem vzorku nevejde do jednoho kontejneru)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.kontejner.deviceId",
        "path" : "logSpecimenInformationCz.kontejner.deviceId",
        "short" : "A.2.6.14.3 - Device Id",
        "definition" : "Unikátní identifikátor kontejneru strojově čitelný.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.kontejner.oznaceni",
        "path" : "logSpecimenInformationCz.kontejner.oznaceni",
        "short" : "A.2.6.14.4 - Označení",
        "definition" : "Lidsky čitelný identifikátor kontejneru.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.dalsiData",
        "path" : "logSpecimenInformationCz.dalsiData",
        "short" : "A.2.6.15 - Další formalizované údaje o vzorku",
        "definition" : "A.2.6.15 - Další formalizované údaje o vzorku",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.dalsiData.datum",
        "path" : "logSpecimenInformationCz.dalsiData.datum",
        "short" : "A.2.6.15.1 - Datum",
        "definition" : "Datum zjištění údaje, uvádí se, pokud je odlišné od data vystavení objednávky.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.dalsiData.kod",
        "path" : "logSpecimenInformationCz.dalsiData.kod",
        "short" : "A.2.6.15.2 - Kód",
        "definition" : "Kód pozorování identifikující význam údaje (interval času sběru, objem sebraného materiálu; hustota; stav materiálu, typ odběru, atd.)\n - Preferovaný systém: NČLPPOL",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.dalsiData.hodnota",
        "path" : "logSpecimenInformationCz.dalsiData.hodnota",
        "short" : "A.2.6.15.3 - Hodnota",
        "definition" : "Hodnota údaje včetně jednotky měření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.odebirajici",
        "path" : "logSpecimenInformationCz.odebirajici",
        "short" : "A.2.6.16 - Odebírající",
        "definition" : "A.2.6.16 - Odebírající",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.odebirajici.id",
        "path" : "logSpecimenInformationCz.odebirajici.id",
        "short" : "A.2.6.16.1 - Identifikátor odebírajícího pracovníka",
        "definition" : "Identifikační číslo odebírajícího pracovníka - jedná se buď o interní identifikátor přidělený provozovatelem zdravotní péče nebo (nejlépe) národní ID zdravotnického pracovníka jako například licence nebo registrační číslo.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.odebirajici.jmeno",
        "path" : "logSpecimenInformationCz.odebirajici.jmeno",
        "short" : "A.2.6.16.2 - Jméno odebírajícího pracovníka",
        "definition" : "Jméno osoby.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.odebirajici.kontakt",
        "path" : "logSpecimenInformationCz.odebirajici.kontakt",
        "short" : "A.2.6.16.3 - Kontaktní údaje odebírajícího pracovníka",
        "definition" : "Kontaktní údaje odebírajícího pracovníka (adresa a telekomunikační údaje).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "logSpecimenInformationCz.odebirajici.organizace",
        "path" : "logSpecimenInformationCz.odebirajici.organizace",
        "short" : "A.2.6.16.4 - Organizace odebírajícího pracovníka",
        "definition" : "Organizace odebírajícího pracovníka (poskytovatel zdravotních služeb).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
