# A.1.6 - Zpracovatel - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.6 - Zpracovatel**

## Logical Model: A.1.6 - Zpracovatel 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logRequestedPerformerCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzRequestedPerformerOrderCz |

 
Předpokládaný zpracovatel žádanky (u neadresné žádanky nebude zpracovatel uveden). 

**Usages:**

* Use this Logical Model: [A.1 - Hlavička dokumentu](StructureDefinition-logHeaderImagingOrder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logRequestedPerformerCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logRequestedPerformerCz.csv), [Excel](StructureDefinition-logRequestedPerformerCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logRequestedPerformerCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logRequestedPerformerCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzRequestedPerformerOrderCz",
  "title" : "A.1.6 - Zpracovatel",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Předpokládaný zpracovatel žádanky (u neadresné žádanky nebude zpracovatel uveden).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logRequestedPerformerCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logRequestedPerformerCz",
        "path" : "logRequestedPerformerCz",
        "short" : "A.1.6 - Zpracovatel",
        "definition" : "Předpokládaný zpracovatel žádanky (u neadresné žádanky nebude zpracovatel uveden)."
      },
      {
        "id" : "logRequestedPerformerCz.id",
        "path" : "logRequestedPerformerCz.id",
        "short" : "A.1.6.1 -ID zpracovatele",
        "definition" : "Identifikátor, který se vztahuje na tuto osobu v této roli.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logRequestedPerformerCz.jmeno",
        "path" : "logRequestedPerformerCz.jmeno",
        "short" : "A.1.6.2 - Jméno zpracovatele",
        "definition" : "Jméno a příjmení osoby zpracovatele žádanky.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "logRequestedPerformerCz.idOrganizace",
        "path" : "logRequestedPerformerCz.idOrganizace",
        "short" : "A.1.6.3 - ID organizace zpracovatele",
        "definition" : "Identifikátor organizace zpracovatele, který se používá k identifikaci organizace v různých informačních systémech.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logRequestedPerformerCz.organizace",
        "path" : "logRequestedPerformerCz.organizace",
        "short" : "A.1.6.4 - Organizace zpracovatele",
        "definition" : "Název, identifikační a kontaktní údaje zdravotnického zařízení zpracovatele, případně také pracoviště zpracovatele.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
