# A.3.2 - Datové elementy objednávky / vyšetření - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.2 - Datové elementy objednávky / vyšetření**

## Logical Model: A.3.2 - Datové elementy objednávky / vyšetření 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logOrderDataElementsCz | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:LogCzOrderDataElementsCz |

 
Datové elementy objednávky / vyšetření 

**Usages:**

* Use this Logical Model: [A.2 a A.3 - Tělo dokumentu](StructureDefinition-logBodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logOrderDataElementsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logOrderDataElementsCz.csv), [Excel](StructureDefinition-logOrderDataElementsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logOrderDataElementsCz",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logOrderDataElementsCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzOrderDataElementsCz",
  "title" : "A.3.2 - Datové elementy objednávky / vyšetření",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Datové elementy objednávky / vyšetření",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logOrderDataElementsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logOrderDataElementsCz",
        "path" : "logOrderDataElementsCz",
        "short" : "A.3.2 - Datové elementy objednávky / vyšetření",
        "definition" : "Datové elementy objednávky / vyšetření"
      },
      {
        "id" : "logOrderDataElementsCz.pozadovaneVysetreni",
        "path" : "logOrderDataElementsCz.pozadovaneVysetreni",
        "short" : "A.3.2.1 - Požadované vyšetření",
        "definition" : "Požadované vyšetření",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logOrderDataElementsCz.kod",
        "path" : "logOrderDataElementsCz.kod",
        "short" : "A.3.2.1.1 - Kód vyšetření",
        "definition" : "Kód reprezentující vyšetření v rámci dohodnutého číselníku včetně jeho názvu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOrderDataElementsCz.nazev",
        "path" : "logOrderDataElementsCz.nazev",
        "short" : "A.3.2.1.2 - Název vyšetření",
        "definition" : "Celý název vyšetření, pokud je odlišný od kódované informace.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logOrderDataElementsCz.modalita",
        "path" : "logOrderDataElementsCz.modalita",
        "short" : "A.3.2.1.3 - Modalita",
        "definition" : "Požadovaná metoda vyšetření (princip měření).",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOrderDataElementsCz.castTela",
        "path" : "logOrderDataElementsCz.castTela",
        "short" : "A.3.2.1.4 - Část těla",
        "definition" : "Vyšetřovaná část těla",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOrderDataElementsCz.lateralita",
        "path" : "logOrderDataElementsCz.lateralita",
        "short" : "A.3.2.1.5 - Lateralita",
        "definition" : "Strana",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOrderDataElementsCz.poznamka",
        "path" : "logOrderDataElementsCz.poznamka",
        "short" : "A.3.2.1.6 - Poznámka",
        "definition" : "Poznámka objednatele k žádanému vyšetření",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
