# A.3.1 - Klinické informace - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.1 - Klinické informace**

## Logical Model: A.3.1 - Klinické informace 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logImageSupportingInformationCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:LogCzImageSupportingInformationCz |

 
Informace a údaje sdělované pracovišti zobrazovacích metod, mající vliv na provedení objednávky či interpretaci výsledků vyšetření 

**Usages:**

* Use this Logical Model: [A.2 a A.3 - Tělo dokumentu](StructureDefinition-logBodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logImageSupportingInformationCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logImageSupportingInformationCz.csv), [Excel](StructureDefinition-logImageSupportingInformationCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logImageSupportingInformationCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logImageSupportingInformationCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzImageSupportingInformationCz",
  "title" : "A.3.1 - Klinické informace",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Informace a údaje sdělované pracovišti zobrazovacích metod, mající vliv na provedení objednávky či interpretaci výsledků vyšetření",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logImageSupportingInformationCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logImageSupportingInformationCz",
        "path" : "logImageSupportingInformationCz",
        "short" : "A.3.1 - Klinické informace",
        "definition" : "Informace a údaje sdělované pracovišti zobrazovacích metod, mající vliv na provedení objednávky či interpretaci výsledků vyšetření"
      },
      {
        "id" : "logImageSupportingInformationCz.biometrickaData",
        "path" : "logImageSupportingInformationCz.biometrickaData",
        "short" : "A.3.1.1 - Biometrické údaje",
        "definition" : "A.3.1.1 - Biometrické údaje",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.biometrickaData.vaha",
        "path" : "logImageSupportingInformationCz.biometrickaData.vaha",
        "short" : "A.3.1.1.1 - Váha",
        "definition" : "Váha subjektu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.biometrickaData.vaha.hodnota",
        "path" : "logImageSupportingInformationCz.biometrickaData.vaha.hodnota",
        "short" : "A.3.1.1.1.1 - Hodnota",
        "definition" : "Hodnota údaje včetně jednotky měření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.biometrickaData.vaha.kod",
        "path" : "logImageSupportingInformationCz.biometrickaData.vaha.kod",
        "short" : "A.3.1.1.1.2 - Kód",
        "definition" : "Kód pozorování identifikující význam údaje váha",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.biometrickaData.vaha.datumACas",
        "path" : "logImageSupportingInformationCz.biometrickaData.vaha.datumACas",
        "short" : "A.3.1.1.1.3 - Datum",
        "definition" : "Datum zjištění údaje, uvádí se, pokud je odlišné od data vystavení objednávky.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.biometrickaData.vyska",
        "path" : "logImageSupportingInformationCz.biometrickaData.vyska",
        "short" : "A.3.1.1.2 - Výška",
        "definition" : "Výška subjektu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.biometrickaData.vyska.hodnota",
        "path" : "logImageSupportingInformationCz.biometrickaData.vyska.hodnota",
        "short" : "A.3.1.1.2.1 - Hodnota",
        "definition" : "Hodnota údaje včetně jednotky měření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.biometrickaData.vyska.kod",
        "path" : "logImageSupportingInformationCz.biometrickaData.vyska.kod",
        "short" : "A.3.1.1.2.2 - Kód",
        "definition" : "Kód pozorování identifikující význam údaje výška",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.biometrickaData.vyska.datumACas",
        "path" : "logImageSupportingInformationCz.biometrickaData.vyska.datumACas",
        "short" : "A.3.1.1.2.3 - Datum",
        "definition" : "Datum zjištění údaje, uvádí se, pokud je odlišné od data vystavení objednávky.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.dalsiRelevantniUdaje",
        "path" : "logImageSupportingInformationCz.dalsiRelevantniUdaje",
        "short" : "A.3.1.2 - Další relevantní klinické informace",
        "definition" : "Další relevantní klinické informace",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.dalsiRelevantniUdaje.kod",
        "path" : "logImageSupportingInformationCz.dalsiRelevantniUdaje.kod",
        "short" : "A.3.1.2.1 - Popis problému / diagnózy / stavu",
        "definition" : "Diagnózy a dalších klinických informací mající vliv na průběh či výsledek vyšetření či jeho interpretaci (např. srdeční selhávání, klaustrofobie, renální selhání)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.dalsiRelevantniUdaje.text",
        "path" : "logImageSupportingInformationCz.dalsiRelevantniUdaje.text",
        "short" : "A.3.1.2.2 - Klinické informace volným textem",
        "definition" : "Klinické informace nezbytné pro správné provedení objednávky či interpretaci výsledků.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.mozneKontraindikaceVlivemMedikaci",
        "path" : "logImageSupportingInformationCz.mozneKontraindikaceVlivemMedikaci",
        "short" : "A.3.1.3 - Možné kontraindikace vyšetření nebo podání kontrastní látky",
        "definition" : "Blok medikace obsahující informace o medikaci mající vliv na průběh či výsledek vyšetření či jeho interpretaci.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.mozneKontraindikaceVlivemMedikaci.medikace",
        "path" : "logImageSupportingInformationCz.mozneKontraindikaceVlivemMedikaci.medikace",
        "short" : "A.3.1.3.1 - Medikace",
        "definition" : "Blok medikace obsahující informace o medikaci mající vliv na průběh či výsledek vyšetření či jeho interpretaci.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.mozneKontraindikaceVlivemMedikaci.medikace.id",
        "path" : "logImageSupportingInformationCz.mozneKontraindikaceVlivemMedikaci.medikace.id",
        "short" : "A.3.1.3.1.1 - ID medikace",
        "definition" : "ID medikace",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.mozneKontraindikaceVlivemMedikaci.medikace.kod",
        "path" : "logImageSupportingInformationCz.mozneKontraindikaceVlivemMedikaci.medikace.kod",
        "short" : "A.3.1.3.1.2 - Kod medikace",
        "definition" : "Kod medikace",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.mozneKontraindikaceVlivemMedikaci.medikace.mnozstvi",
        "path" : "logImageSupportingInformationCz.mozneKontraindikaceVlivemMedikaci.medikace.mnozstvi",
        "short" : "A.3.1.3.1.3 - Mnozstvi",
        "definition" : "Mnozstvi medikace",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Ratio"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.implantat",
        "path" : "logImageSupportingInformationCz.implantat",
        "short" : "A.3.1.4 - Implantat",
        "definition" : "Seznam implantátů či pomůcek majících vliv na průběh vyšetření či jeho interpretaci.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.implantat.typ",
        "path" : "logImageSupportingInformationCz.implantat.typ",
        "short" : "A.3.1.4.1 - Druh implantátu",
        "definition" : "Druh implantátu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.implantat.id",
        "path" : "logImageSupportingInformationCz.implantat.id",
        "short" : "A.3.1.4.2 - ID implantátu",
        "definition" : "Normalizovaný identifikátor, např. UDI, dle nařízení EU 2017/745, kód ZP dle katalogu zdravotní pojišťovny",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.implantat.model",
        "path" : "logImageSupportingInformationCz.implantat.model",
        "short" : "A.3.1.4.3 - Konkrétní model",
        "definition" : "Konkrétní model",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.implantat.castTela",
        "path" : "logImageSupportingInformationCz.implantat.castTela",
        "short" : "A.3.1.4.4 - Část těla",
        "definition" : "Část těla, kam je implantován",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.urgentniInformace",
        "path" : "logImageSupportingInformationCz.urgentniInformace",
        "short" : "A.3.1.5 - Urgentní informace",
        "definition" : "Blok urgentní informace ve stejné struktuře jako v ostatních typech dokumentů (propouštěcí zpráva, pacientský souhrn)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.urgentniInformace.allergie",
        "path" : "logImageSupportingInformationCz.urgentniInformace.allergie",
        "short" : "A.3.1.5.1 - Alergie a intolerance",
        "definition" : "Alergie a intolerance, které mohou ovlivnit realizaci objednávky či interpretaci výsledků.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.urgentniInformace.varovani",
        "path" : "logImageSupportingInformationCz.urgentniInformace.varovani",
        "short" : "A.3.1.5.2 - Varování",
        "definition" : "Varování a upozornění, která mohou vlivní realizaci objednávky či interpretaci výsledků.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.omezeniPohyblivostiPacienta",
        "path" : "logImageSupportingInformationCz.omezeniPohyblivostiPacienta",
        "short" : "A.3.1.6 - Omezení pohyblivosti pacienta",
        "definition" : "Omezení pohyblivosti pacienta",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.dalsiUdaje",
        "path" : "logImageSupportingInformationCz.dalsiUdaje",
        "short" : "A.3.1.7 - Další formalizované údaje",
        "definition" : "Další formalizované údaje sdělované provádějícímu pracovišti",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.dalsiUdaje.datumACas",
        "path" : "logImageSupportingInformationCz.dalsiUdaje.datumACas",
        "short" : "A.3.1.7.1 - Datum",
        "definition" : "Datum zjištění údaje, uvádí se, pokud je odlišné od data vystavení objednávky.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.dalsiUdaje.kod",
        "path" : "logImageSupportingInformationCz.dalsiUdaje.kod",
        "short" : "A.3.1.7.2 - Kód",
        "definition" : "Kód pozorování identifikující význam údaje (týden gravidity apod.).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logImageSupportingInformationCz.dalsiUdaje.hodnota",
        "path" : "logImageSupportingInformationCz.dalsiUdaje.hodnota",
        "short" : "A.3.1.7.3 - Hodnota",
        "definition" : "Hodnota údaje včetně jednotky měření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      }
    ]
  }
}

```
