# A.2.1 - Informace o objednávce and A.2.2 - Odůvodnění vyšetření (důvod objednávky) - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.1 - Informace o objednávce and A.2.2 - Odůvodnění vyšetření (důvod objednávky)**

## Logical Model: A.2.1 - Informace o objednávce and A.2.2 - Odůvodnění vyšetření (důvod objednávky) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logImageOrderInformationCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzImageOrderInformationCz |

 
Informace o objednávce a Odůvodnění vyšetření (důvod objednávky) 

**Usages:**

* Use this Logical Model: [A.2 a A.3 - Tělo dokumentu](StructureDefinition-logBodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logImageOrderInformationCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logImageOrderInformationCz.csv), [Excel](StructureDefinition-logImageOrderInformationCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logImageOrderInformationCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logImageOrderInformationCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzImageOrderInformationCz",
  "title" : "A.2.1 - Informace o objednávce and A.2.2 - Odůvodnění vyšetření (důvod objednávky)",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Informace o objednávce a Odůvodnění vyšetření (důvod objednávky)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logImageOrderInformationCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logImageOrderInformationCz",
        "path" : "logImageOrderInformationCz",
        "short" : "A.2.1 - Informace o objednávce and A.2.2 - Odůvodnění vyšetření (důvod objednávky)",
        "definition" : "Informace o objednávce a Odůvodnění vyšetření (důvod objednávky)"
      },
      {
        "id" : "logImageOrderInformationCz.detailyObjednavky",
        "path" : "logImageOrderInformationCz.detailyObjednavky",
        "short" : "A.2.1 - Informace o objednávce",
        "definition" : "Informace o objednávce",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logImageOrderInformationCz.detailyObjednavky.id",
        "path" : "logImageOrderInformationCz.detailyObjednavky.id",
        "short" : "A.2.1.1 - ID objednávky",
        "definition" : "Identifikátor objednávky vyšetření.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logImageOrderInformationCz.detailyObjednavky.datumACas",
        "path" : "logImageOrderInformationCz.detailyObjednavky.datumACas",
        "short" : "A.2.1.2 - Datum a čas objednávky",
        "definition" : "Datum a čas zadání objednávky.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logImageOrderInformationCz.detailyObjednavky.datumPozadovanehoProvedeni",
        "path" : "logImageOrderInformationCz.detailyObjednavky.datumPozadovanehoProvedeni",
        "short" : "A.2.1.3 - Datum a čas požadovaného provedení",
        "definition" : "Datum a čas požadovaného provedení",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logImageOrderInformationCz.detailyObjednavky.urgentnost",
        "path" : "logImageOrderInformationCz.detailyObjednavky.urgentnost",
        "short" : "A.2.1.4 - Urgentnost objednávky",
        "definition" : "Urgentnost objednávky (rutinní, urgentní, statim).  \n- Preferovaný systém: HL7:RequestPriority",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logImageOrderInformationCz.detailyObjednavky.textObjednavky",
        "path" : "logImageOrderInformationCz.detailyObjednavky.textObjednavky",
        "short" : "A.2.1.5 - Text objednávky",
        "definition" : "Textový popis objednávky či doplňující požadavky, specifické pro jednotlivé typy objednávek, pokud je nelze vyjádřit formalizovaně.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logImageOrderInformationCz.detailyObjednavky.infoProPacienta",
        "path" : "logImageOrderInformationCz.detailyObjednavky.infoProPacienta",
        "short" : "A.2.1.6 - Informace pro pacienta",
        "definition" : "Instrukce pro pacienta související s objednávkou. Např. na lačno apod.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logImageOrderInformationCz.duvodObjednavky",
        "path" : "logImageOrderInformationCz.duvodObjednavky",
        "short" : "A.2.2 - Odůvodnění vyšetření (důvod objednávky)",
        "definition" : "Odůvodnění vyšetření (důvod objednávky)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logImageOrderInformationCz.duvodObjednavky.problem",
        "path" : "logImageOrderInformationCz.duvodObjednavky.problem",
        "short" : "A.2.2.1 - Popis problému / diagnózy / stavu – indikační diagnóza",
        "definition" : "Důvod vystavení objednávky k vyšetření vyjádřený strukturovaným textem a/nebo kódem.\n- Preferovaný systém: MKN-10\n- Preferovaný systém: Orphacode",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logImageOrderInformationCz.duvodObjednavky.klinickaOtazkaKod",
        "path" : "logImageOrderInformationCz.duvodObjednavky.klinickaOtazkaKod",
        "short" : "A.2.2.2 - Klinická otázka kódem",
        "definition" : "kódovaná informace z 2.2.3, pokud je zadána\n- Preferovaný systém: SNOMED CT",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logImageOrderInformationCz.duvodObjednavky.klinickaOtazkaText",
        "path" : "logImageOrderInformationCz.duvodObjednavky.klinickaOtazkaText",
        "short" : "A.2.2.3 - Klinická otázka textem",
        "definition" : "Klinická otázka, na kterou má provedení zobrazovací metody odpovědět. Příklad: \\\"Nemá pacient nádor plic?\\\".",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logImageOrderInformationCz.duvodObjednavky.duvodKod",
        "path" : "logImageOrderInformationCz.duvodObjednavky.duvodKod",
        "short" : "A.2.2.4 - Důvod objednávky kódem",
        "definition" : "kódovaná informace z 2.2.5, pokud je zadána\n- Preferovaný systém: SNOMED CT ReasonCodelist 243796009",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logImageOrderInformationCz.duvodObjednavky.duvodText",
        "path" : "logImageOrderInformationCz.duvodObjednavky.duvodText",
        "short" : "A.2.2.5 - Důvod objednávky textem",
        "definition" : "Důvod vystavení objednávky k vyšetření vyjádřený volným textem (např. \\\"3 týdny neustupující kašel\\\")",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
