# A.1.8 - Metadata dokumentu - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.8 - Metadata dokumentu**

## Logical Model: A.1.8 - Metadata dokumentu 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logDocumentMetadataCz | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:LogCzDocumentMetadataOrderCz |

 
Metadata dokumentu 

**Usages:**

* Use this Logical Model: [A.1 - Hlavička dokumentu](StructureDefinition-logHeaderImagingOrder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logDocumentMetadataCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logDocumentMetadataCz.csv), [Excel](StructureDefinition-logDocumentMetadataCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logDocumentMetadataCz",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logDocumentMetadataCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzDocumentMetadataOrderCz",
  "title" : "A.1.8 - Metadata dokumentu",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Metadata dokumentu",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logDocumentMetadataCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logDocumentMetadataCz",
        "path" : "logDocumentMetadataCz",
        "short" : "A.1.8 - Metadata dokumentu",
        "definition" : "Metadata dokumentu"
      },
      {
        "id" : "logDocumentMetadataCz.idDokumentu",
        "path" : "logDocumentMetadataCz.idDokumentu",
        "short" : "A.1.8.1 - ID dokumentu",
        "definition" : "Identifikátor dokumentu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logDocumentMetadataCz.kategorie",
        "path" : "logDocumentMetadataCz.kategorie",
        "short" : "A.1.8.2 - Kategorie",
        "definition" : "Kategorie elektronického zdravotního záznamu (EHR).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logDocumentMetadataCz.stav",
        "path" : "logDocumentMetadataCz.stav",
        "short" : "A.1.8.3 - Stav",
        "definition" : "Stav dokumentu (předběžný, finální, doplněný, opravený atp.).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logDocumentMetadataCz.datumACas",
        "path" : "logDocumentMetadataCz.datumACas",
        "short" : "A.1.8.4 - Datum a čas vytvoření",
        "definition" : "Datum a čas vytvoření dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logDocumentMetadataCz.nazev",
        "path" : "logDocumentMetadataCz.nazev",
        "short" : "A.1.8.5 - Název dokumentu",
        "definition" : "Název dokumentu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logDocumentMetadataCz.spravce",
        "path" : "logDocumentMetadataCz.spravce",
        "short" : "A.1.8.6 - Správce dokumentu",
        "definition" : "Název a identifikační údaje subjektu, který dokument spravuje. Alias technický správce dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logDocumentMetadataCz.duvernost",
        "path" : "logDocumentMetadataCz.duvernost",
        "short" : "A.1.8.7 - Důvěrnost",
        "definition" : "Stupeň důvěrnosti dokumentu (a jeho obsahu).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logDocumentMetadataCz.jazyk",
        "path" : "logDocumentMetadataCz.jazyk",
        "short" : "A.1.8.8 - Jazyk",
        "definition" : "Jazyk, v němž je dokument napsán (narativní část dokumentu).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logDocumentMetadataCz.verze",
        "path" : "logDocumentMetadataCz.verze",
        "short" : "A.1.8.9 - Verze",
        "definition" : "Verze dokumentu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
