# A.2 a A.3 - Tělo dokumentu - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2 a A.3 - Tělo dokumentu**

## Logical Model: A.2 a A.3 - Tělo dokumentu 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logBodyImageOrderCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:LogCzBodyImageOrderCz |

 
Tělo dokumentu 

**Usages:**

* Use this Logical Model: [A - Žádanka obrazového vyšetření](StructureDefinition-logImagingOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logBodyImageOrderCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logBodyImageOrderCz.csv), [Excel](StructureDefinition-logBodyImageOrderCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logBodyImageOrderCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logBodyImageOrderCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzBodyImageOrderCz",
  "title" : "A.2 a A.3 - Tělo dokumentu",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Tělo dokumentu",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logBodyImageOrderCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logBodyImageOrderCz",
        "path" : "logBodyImageOrderCz",
        "short" : "A.2 a A.3 - Tělo dokumentu",
        "definition" : "Tělo dokumentu"
      },
      {
        "id" : "logBodyImageOrderCz.infoOObjednavce",
        "path" : "logBodyImageOrderCz.infoOObjednavce",
        "short" : "A.2.1 - Informace o objednávce a A.2.2 Odůvodnění vyšetření",
        "definition" : "A.2.1 - Informace o objednávce a A.2.2 Odůvodnění vyšetření",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logImageOrderInformationCz"
          }
        ]
      },
      {
        "id" : "logBodyImageOrderCz.klinickaUdalost",
        "path" : "logBodyImageOrderCz.klinickaUdalost",
        "short" : "A.2.3 - Klinická událost",
        "definition" : "Informace o klinické události, ke které se objednávka vztahuje (odkaz na návštěvu)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logClinicalEventCz"
          }
        ]
      },
      {
        "id" : "logBodyImageOrderCz.uhrada",
        "path" : "logBodyImageOrderCz.uhrada",
        "short" : "A.2.4 - Úhrada",
        "definition" : "Informace o způsobu úhrady objednávky vyšetření",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logCoverageBodyCz"
          }
        ]
      },
      {
        "id" : "logBodyImageOrderCz.terminNastevy",
        "path" : "logBodyImageOrderCz.terminNastevy",
        "short" : "A.2.5 - Termín návštěvy",
        "definition" : "Informace o objednaném termínu vyšetření (pokud byl termín rezervován)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logImageAppointmentCz"
          }
        ]
      },
      {
        "id" : "logBodyImageOrderCz.infoOVzorku",
        "path" : "logBodyImageOrderCz.infoOVzorku",
        "short" : "A.2.6 - Informace o vzorku",
        "definition" : "Pro specifická obrazová vyšetření vzorku",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logSpecimenInformationCz"
          }
        ]
      },
      {
        "id" : "logBodyImageOrderCz.klinickeInformace",
        "path" : "logBodyImageOrderCz.klinickeInformace",
        "short" : "A.3.1 - Klinické informace",
        "definition" : "Informace a údaje sdělované pracovišti zobrazovacích metod, mající vliv na provedení objednávky či interpretaci výsledků vyšetření",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logImageSupportingInformationCz"
          }
        ]
      },
      {
        "id" : "logBodyImageOrderCz.datoveElementy",
        "path" : "logBodyImageOrderCz.datoveElementy",
        "short" : "A.3.2 - Datové elementy objednávky / vyšetření",
        "definition" : "Informace o požadovaných vyšetřeních",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logOrderDataElementsCz"
          }
        ]
      },
      {
        "id" : "logBodyImageOrderCz.planovanaPece",
        "path" : "logBodyImageOrderCz.planovanaPece",
        "short" : "A.3.3 - Objednávky plánované péče",
        "definition" : "Odkazy na objednávky plánované péče navazující na tuto žádanku",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logPlannedCareOrdersCz"
          }
        ]
      },
      {
        "id" : "logBodyImageOrderCz.dalsiPodpurneInformace",
        "path" : "logBodyImageOrderCz.dalsiPodpurneInformace",
        "short" : "A.3.4 - Další podpůrné informace",
        "definition" : "Ostatní podpůrné informace",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logOtherSupportingInformationCz"
          }
        ]
      }
    ]
  }
}

```
