# A.1.5 - Objednatel - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.5 - Objednatel**

## Logical Model: A.1.5 - Objednatel 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logAuthorCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzAuthorOrderCz |

 
Objednatel (Objednatel provedení zdravotní služby). 

**Usages:**

* Use this Logical Model: [A.1 - Hlavička dokumentu](StructureDefinition-logHeaderImagingOrder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logAuthorCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logAuthorCz.csv), [Excel](StructureDefinition-logAuthorCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logAuthorCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logAuthorCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzAuthorOrderCz",
  "title" : "A.1.5 - Objednatel",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Objednatel (Objednatel provedení zdravotní služby).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logAuthorCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logAuthorCz",
        "path" : "logAuthorCz",
        "short" : "A.1.5 - Objednatel",
        "definition" : "Objednatel (Objednatel provedení zdravotní služby)."
      },
      {
        "id" : "logAuthorCz.identifikator",
        "path" : "logAuthorCz.identifikator",
        "short" : "A.1.5.1 - Identifikátor zadavatele objednávky",
        "definition" : "Identifikační číslo zdravotnického pracovníka –  národní ID zdravotnického pracovníka vedený v KRZP. V případě, že není objednávka zadána zdravotnickým pracovníkem, ale například samotným pacientem, měl by být použit osobní identifikátor RID (případně DRID).",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logAuthorCz.jmeno",
        "path" : "logAuthorCz.jmeno",
        "short" : "A.1.5.2 - Jméno zadavatele objednávky",
        "definition" : "Jméno objednavatele",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "logAuthorCz.adresa",
        "path" : "logAuthorCz.adresa",
        "short" : "A.1.5.3 - Kontaktní údaje zadavatele objednávky",
        "definition" : "Kontaktní údaje zadavatele objednávky (adresa a telekomunikační údaje).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAuthorCz.organizace",
        "path" : "logAuthorCz.organizace",
        "short" : "A.1.5.4 - Organizace zadavatele objednávky",
        "definition" : "Organizace zadavatele objednávky (poskytovatel zdravotních služeb).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
