# A.5 - Přílohy - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.5 - Přílohy**

## Logical Model: A.5 - Přílohy 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logAttachmentsCz | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:LogCzAttachmentsCz |

 
Ostatní přílohy. 

**Usages:**

* Use this Logical Model: [A - Žádanka obrazového vyšetření](StructureDefinition-logImagingOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logAttachmentsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logAttachmentsCz.csv), [Excel](StructureDefinition-logAttachmentsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logAttachmentsCz",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logAttachmentsCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzAttachmentsCz",
  "title" : "A.5 - Přílohy",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Ostatní přílohy.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logAttachmentsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logAttachmentsCz",
        "path" : "logAttachmentsCz",
        "short" : "A.5 - Přílohy",
        "definition" : "Ostatní přílohy."
      },
      {
        "id" : "logAttachmentsCz.typObsahu",
        "path" : "logAttachmentsCz.typObsahu",
        "short" : "A.5.1 - Typ obsahu",
        "definition" : "Typ obsahu - je  požadován MIME typ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAttachmentsCz.jazyk",
        "path" : "logAttachmentsCz.jazyk",
        "short" : "A.5.2 - Jazyk obsahu",
        "definition" : "Jazyk obsahu - je požadována hodnata z HL7 valueset Languages",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAttachmentsCz.data",
        "path" : "logAttachmentsCz.data",
        "short" : "A.5.3 - Data obsahu",
        "definition" : "Data v base64",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ]
      },
      {
        "id" : "logAttachmentsCz.url",
        "path" : "logAttachmentsCz.url",
        "short" : "A.5.4 - URL obsahu",
        "definition" : "Uri kde lze data nalézt",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "url"
          }
        ]
      },
      {
        "id" : "logAttachmentsCz.nazev",
        "path" : "logAttachmentsCz.nazev",
        "short" : "A.5.5 - Název obsahu",
        "definition" : "Titulek, který bude zobrazen před daty",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logAttachmentsCz.vytvoreni",
        "path" : "logAttachmentsCz.vytvoreni",
        "short" : "A.5.6 - Datum vytvoření",
        "definition" : "Datum, kdy byl obsah poprvé vytvořen",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
