# Service Request: Imaging Order (CZ) - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Service Request: Imaging Order (CZ)**

## Resource Profile: Service Request: Imaging Order (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/cz-imagingOrderInformation | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:CZ_ImagingOrderInformation |

 
Order information for the scope of the Czech national interoperability project. 

**Usages:**

* Use this Profile: [Bundle: Imaging Order (CZ)](StructureDefinition-cz-bundleImageOrder.md)
* Refer to this Profile: [Composition: Imaging Order (CZ)](StructureDefinition-cz-compositionImageOrder.md)
* Examples for this Profile: [ServiceRequest/158808ba-fcca-480e-8188-dec77920ec3c](ServiceRequest-158808ba-fcca-480e-8188-dec77920ec3c.md), [ServiceRequest/210db397-977a-47a0-8a2e-febde6f9f92a](ServiceRequest-210db397-977a-47a0-8a2e-febde6f9f92a.md), [ServiceRequest/5ab3e344-4d0c-4786-bab2-7dd0d7b60cd9](ServiceRequest-5ab3e344-4d0c-4786-bab2-7dd0d7b60cd9.md), [ServiceRequest/c8d7d3d8-9007-45a7-8f09-0ae69f7d7fed](ServiceRequest-c8d7d3d8-9007-45a7-8f09-0ae69f7d7fed.md)...Show 4 more,[ServiceRequest/cz-imagingorder-example](ServiceRequest-cz-imagingorder-example.md),[ServiceRequest/d6784779-d008-447d-90cf-89d5d53a0f04](ServiceRequest-d6784779-d008-447d-90cf-89d5d53a0f04.md),[ServiceRequest/ded5bee9-8a58-4676-919f-0b8e08eaede4](ServiceRequest-ded5bee9-8a58-4676-919f-0b8e08eaede4.md)and[ServiceRequest/fea1dbb8-9e16-4e11-beae-c12829c97381](ServiceRequest-fea1dbb8-9e16-4e11-beae-c12829c97381.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/cz-imagingOrderInformation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-imagingOrderInformation.csv), [Excel](StructureDefinition-cz-imagingOrderInformation.xlsx), [Schematron](StructureDefinition-cz-imagingOrderInformation.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-imagingOrderInformation",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-imagingOrderInformation",
  "version" : "0.1.0-ballot",
  "name" : "CZ_ImagingOrderInformation",
  "title" : "Service Request: Imaging Order (CZ)",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Order information for the scope of the Czech national interoperability project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ServiceRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ServiceRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ServiceRequest.text",
        "path" : "ServiceRequest.text",
        "min" : 1
      },
      {
        "id" : "ServiceRequest.extension",
        "path" : "ServiceRequest.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "ServiceRequest.extension:bodySite",
        "path" : "ServiceRequest.extension",
        "sliceName" : "bodySite",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/bodySite|5.2.0"]
          }
        ]
      },
      {
        "id" : "ServiceRequest.extension:bodySite.value[x]",
        "path" : "ServiceRequest.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/BodyStructure-cz"
            ]
          }
        ]
      },
      {
        "id" : "ServiceRequest.identifier",
        "path" : "ServiceRequest.identifier",
        "min" : 1
      },
      {
        "id" : "ServiceRequest.category",
        "path" : "ServiceRequest.category",
        "min" : 1
      },
      {
        "id" : "ServiceRequest.code.coding",
        "path" : "ServiceRequest.code.coding",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://hl7.cz/fhir/img-order/ValueSet/cz-imaging-procedure-vs"
        }
      },
      {
        "id" : "ServiceRequest.orderDetail.coding",
        "path" : "ServiceRequest.orderDetail.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ServiceRequest.orderDetail.coding:modality",
        "path" : "ServiceRequest.orderDetail.coding",
        "sliceName" : "modality",
        "min" : 1,
        "max" : "*",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://hl7.cz/fhir/img-order/ValueSet/cz-modality-vs"
        }
      },
      {
        "id" : "ServiceRequest.orderDetail.coding:modality.system",
        "path" : "ServiceRequest.orderDetail.coding.system",
        "min" : 1,
        "patternUri" : "http://dicom.nema.org/resources/ontology/DCM"
      },
      {
        "id" : "ServiceRequest.subject",
        "path" : "ServiceRequest.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "ServiceRequest.authoredOn",
        "path" : "ServiceRequest.authoredOn",
        "min" : 1
      },
      {
        "id" : "ServiceRequest.performer",
        "path" : "ServiceRequest.performer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "http://hl7.org/fhir/StructureDefinition/CareTeam",
              "http://hl7.org/fhir/StructureDefinition/HealthcareService",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-device-observer"
            ]
          }
        ]
      },
      {
        "id" : "ServiceRequest.performer.type",
        "path" : "ServiceRequest.performer.type",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/device-type"
        }
      },
      {
        "id" : "ServiceRequest.reasonCode.coding",
        "path" : "ServiceRequest.reasonCode.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "ServiceRequest.reasonCode.coding:diagnosis",
        "path" : "ServiceRequest.reasonCode.coding",
        "sliceName" : "diagnosis",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://terminology.uzis.cz/ValueSet/Mkn10_5"
        }
      },
      {
        "id" : "ServiceRequest.reasonCode.coding:diagnosis.system",
        "path" : "ServiceRequest.reasonCode.coding.system",
        "min" : 1,
        "patternUri" : "https://terminology.uzis.cz/CodeSystem/Mkn10_5"
      },
      {
        "id" : "ServiceRequest.reasonCode.coding:reason",
        "path" : "ServiceRequest.reasonCode.coding",
        "sliceName" : "reason",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-code"
        }
      },
      {
        "id" : "ServiceRequest.reasonCode.coding:reason.system",
        "path" : "ServiceRequest.reasonCode.coding.system",
        "min" : 1,
        "fixedUri" : "http://snomed.info/sct"
      },
      {
        "id" : "ServiceRequest.insurance",
        "path" : "ServiceRequest.insurance",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-coverage"]
          }
        ]
      },
      {
        "id" : "ServiceRequest.supportingInfo",
        "path" : "ServiceRequest.supportingInfo",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement",
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bodyheight",
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bodyweight",
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-potientMobility",
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device",
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-observationImage",
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-carePlanImage"
            ]
          }
        ]
      },
      {
        "id" : "ServiceRequest.specimen",
        "path" : "ServiceRequest.specimen",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-specimen"]
          }
        ]
      },
      {
        "id" : "ServiceRequest.bodySite",
        "path" : "ServiceRequest.bodySite",
        "max" : "1",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      }
    ]
  }
}

```
