# Device Use Statement: Imaging Order (CZ) - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Device Use Statement: Imaging Order (CZ)**

## Resource Profile: Device Use Statement: Imaging Order (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/cz-deviceUseStatement | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:CZ_DeviceUseStatement |

 
This profile represents the constraints applied to the DeviceUseStatement resource for the purpose of this guide. A device used by or implanted on the patient is described in the imaging order as an instance of a Device resource constrained by this profile. 

**Usages:**

* Use this Profile: [Bundle: Imaging Order (CZ)](StructureDefinition-cz-bundleImageOrder.md)
* Refer to this Profile: [Composition: Imaging Order (CZ)](StructureDefinition-cz-compositionImageOrder.md)
* Examples for this Profile: [DeviceUseStatement/b29cacfd-b05b-44cf-be5a-8b6d76bdc375](DeviceUseStatement-b29cacfd-b05b-44cf-be5a-8b6d76bdc375.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/cz-deviceUseStatement)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-deviceUseStatement.csv), [Excel](StructureDefinition-cz-deviceUseStatement.xlsx), [Schematron](StructureDefinition-cz-deviceUseStatement.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-deviceUseStatement",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-deviceUseStatement",
  "version" : "0.1.0-ballot",
  "name" : "CZ_DeviceUseStatement",
  "title" : "Device Use Statement: Imaging Order (CZ)",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile represents the constraints applied to the DeviceUseStatement resource for the purpose of this guide. A device used by or implanted on the patient is described in the imaging order as an instance of a Device resource constrained by this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DeviceUseStatement",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DeviceUseStatement",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DeviceUseStatement.text",
        "path" : "DeviceUseStatement.text",
        "short" : "Device usage description"
      },
      {
        "id" : "DeviceUseStatement.subject",
        "path" : "DeviceUseStatement.subject",
        "definition" : "The patient using the device.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "DeviceUseStatement.timing[x]",
        "path" : "DeviceUseStatement.timing[x]",
        "min" : 1
      },
      {
        "id" : "DeviceUseStatement.timing[x].extension:data-absent-reason",
        "path" : "DeviceUseStatement.timing[x].extension",
        "sliceName" : "data-absent-reason",
        "definition" : "Provides a reason why the timing is missing.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/data-absent-reason|4.0.1"
            ]
          }
        ]
      },
      {
        "id" : "DeviceUseStatement.device",
        "path" : "DeviceUseStatement.device",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device"
            ]
          }
        ]
      },
      {
        "id" : "DeviceUseStatement.reasonCode",
        "path" : "DeviceUseStatement.reasonCode",
        "short" : "Why is used (code)"
      },
      {
        "id" : "DeviceUseStatement.reasonReference",
        "path" : "DeviceUseStatement.reasonReference",
        "short" : "Why is used (details)",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-observationImage",
              "http://hl7.org/fhir/StructureDefinition/Media",
              "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "DeviceUseStatement.bodySite",
        "path" : "DeviceUseStatement.bodySite",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      }
    ]
  }
}

```
