# Condition: Clinical question (CZ) - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Condition: Clinical question (CZ)**

## Resource Profile: Condition: Clinical question (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/cz-conditionClinicalQuestion | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:CZ_ConditionClinicalQuestion |

 
Condition for purpose of clinical question in Imaging Order for the scope of the Czech national interoperability project. 

**Usages:**

* Refer to this Profile: [Composition: Imaging Order (CZ)](StructureDefinition-cz-compositionImageOrder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/cz-conditionClinicalQuestion)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-conditionClinicalQuestion.csv), [Excel](StructureDefinition-cz-conditionClinicalQuestion.xlsx), [Schematron](StructureDefinition-cz-conditionClinicalQuestion.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-conditionClinicalQuestion",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-conditionClinicalQuestion",
  "version" : "0.1.0-ballot",
  "name" : "CZ_ConditionClinicalQuestion",
  "title" : "Condition: Clinical question (CZ)",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Condition for purpose of clinical question in Imaging Order for the scope of the Czech national interoperability project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-conditionImage",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition"
      },
      {
        "id" : "Condition.code.coding",
        "path" : "Condition.code.coding",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-code"
        }
      },
      {
        "id" : "Condition.code.text",
        "path" : "Condition.code.text",
        "min" : 1
      }
    ]
  }
}

```
