# Bundle: Imaging Order (CZ) - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Bundle: Imaging Order (CZ)**

## Resource Profile: Bundle: Imaging Order (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/cz-bundleImageOrder | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_BundleImageOrder |
| **Copyright/Legal**: HL7 CZ | | |

 
Clinical document used to represent a Imaging Order for the scope of this guide. 

 
Imaging order bundle is an electronic health record extract containing results of imaging from a subject of care, comprising at least the required elements of the imaging dataset. 

**Usages:**

* Examples for this Profile: [Bundle/BundleKralikRTG](Bundle-BundleKralikRTG.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/cz-bundleImageOrder)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-bundleImageOrder.csv), [Excel](StructureDefinition-cz-bundleImageOrder.xlsx), [Schematron](StructureDefinition-cz-bundleImageOrder.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-bundleImageOrder",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bundleImageOrder",
  "version" : "0.1.0-ballot",
  "name" : "CZ_BundleImageOrder",
  "title" : "Bundle: Imaging Order (CZ)",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Clinical document used to represent a Imaging Order for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "Imaging order bundle is an electronic health record extract containing results of imaging from a subject of care, comprising at least the required elements of the imaging dataset.",
  "copyright" : "HL7 CZ",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "short" : "Imaging Order Bundle",
        "definition" : "Imaging Order Bundle. \r\nA container for a collection of resources in the inmaging order document.",
        "constraint" : [
          {
            "key" : "one-comp",
            "severity" : "error",
            "human" : "A imaging order bundle SHALL include one and only one Composition",
            "expression" : "entry.resource.ofType(Composition).count() = 1",
            "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bundleImageOrder"
          },
          {
            "key" : "same-servicerequest-performer",
            "severity" : "warning",
            "human" : "Service requests SHALL have the same performer.",
            "expression" : "entry.resource.ofType(ServiceRequest).contained.all($this.performer = entry.resource.ofType(ServiceRequest).performer)",
            "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bundleImageOrder"
          },
          {
            "key" : "same-servicerequest-occurrence",
            "severity" : "warning",
            "human" : "Service requests SHALL have the same occurrence (dateTime or period).",
            "expression" : "entry.resource.ofType(ServiceRequest).contained.all($this.occurrence = entry.resource.ofType(ServiceRequest).occurrence)",
            "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bundleImageOrder"
          },
          {
            "key" : "coverage-author",
            "severity" : "error",
            "human" : "If coverage is an insurance company than the author must have filled organization.identifier and specialty.",
            "expression" : "entry.resource.ofType(Coverage).payor.resolve().ofType(Organization).identifier.where($this.system = 'https://ncez.mzcr.cz/fhir/sid/kp') implies (entry.resource.ofType(Composition).author.resolve().ofType(PractitionerRole).specialty.exists() and entry.resource.ofType(Composition).author.resolve().ofType(PractitionerRole).organization.resolve().ofType(Organization).identifier.where($this.system = 'https://ncez.mzcr.cz/fhir/sid/icp'))",
            "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bundleImageOrder"
          }
        ]
      },
      {
        "id" : "Bundle.identifier",
        "path" : "Bundle.identifier",
        "short" : "Business identifier for this Imaging order",
        "min" : 1
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "patternCode" : "document"
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "min" : 1
      },
      {
        "id" : "Bundle.total",
        "path" : "Bundle.total",
        "max" : "0"
      },
      {
        "id" : "Bundle.link",
        "path" : "Bundle.link",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            },
            {
              "type" : "profile",
              "path" : "resource"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Entry resource in the Imaging order bundle",
        "definition" : "An entry resource included in the Imaging order document bundle resource.",
        "comment" : "Must contain the Imaging Order Composition as the first entry (only a single Composition resource instance may be included).  Additional constraints are specified in the Imaging Order Composition profile.",
        "min" : 2
      },
      {
        "id" : "Bundle.entry.link",
        "path" : "Bundle.entry.link",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.request",
        "path" : "Bundle.entry.request",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:composition",
        "path" : "Bundle.entry",
        "sliceName" : "composition",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:composition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Composition",
            "profile" : [
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-compositionImageOrder"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-animal"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:orderInformation",
        "path" : "Bundle.entry",
        "sliceName" : "orderInformation",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:orderInformation.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "ServiceRequest",
            "profile" : [
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-imagingOrderInformation"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:appointment",
        "path" : "Bundle.entry",
        "sliceName" : "appointment",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:appointment.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Appointment",
            "profile" : [
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-appointment"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:specimen",
        "path" : "Bundle.entry",
        "sliceName" : "specimen",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:specimen.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Specimen",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-specimen"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitioner",
        "path" : "Bundle.entry",
        "sliceName" : "practitioner",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:practitioner.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Practitioner",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitionerRole",
        "path" : "Bundle.entry",
        "sliceName" : "practitionerRole",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:practitionerRole.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "PractitionerRole",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:coverage",
        "path" : "Bundle.entry",
        "sliceName" : "coverage",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:coverage.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Coverage",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-coverage"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medication",
        "path" : "Bundle.entry",
        "sliceName" : "medication",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medication.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MedicationStatement",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:condition",
        "path" : "Bundle.entry",
        "sliceName" : "condition",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:condition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Condition",
            "profile" : [
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-conditionImage"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:allergyIntolerance",
        "path" : "Bundle.entry",
        "sliceName" : "allergyIntolerance",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:allergyIntolerance.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "AllergyIntolerance",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:carePlan",
        "path" : "Bundle.entry",
        "sliceName" : "carePlan",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:carePlan.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "CarePlan",
            "profile" : [
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-carePlanImage"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observation",
        "path" : "Bundle.entry",
        "sliceName" : "observation",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Observation"
          }
        ]
      },
      {
        "id" : "Bundle.entry:deviceUse",
        "path" : "Bundle.entry",
        "sliceName" : "deviceUse",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:deviceUse.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "DeviceUseStatement",
            "profile" : [
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-deviceUseStatement"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:device",
        "path" : "Bundle.entry",
        "sliceName" : "device",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:device.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Device"
          }
        ]
      },
      {
        "id" : "Bundle.entry:attachment",
        "path" : "Bundle.entry",
        "sliceName" : "attachment",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:attachment.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "DocumentReference"
          }
        ]
      },
      {
        "id" : "Bundle.entry:organisation",
        "path" : "Bundle.entry",
        "sliceName" : "organisation",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:organisation.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:encounter",
        "path" : "Bundle.entry",
        "sliceName" : "encounter",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:encounter.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Encounter",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-encounter"]
          }
        ]
      },
      {
        "id" : "Bundle.signature",
        "path" : "Bundle.signature",
        "short" : "Digital Signature of this order",
        "type" : [
          {
            "code" : "Signature",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-signature"]
          }
        ]
      }
    ]
  }
}

```
