# Body Height: Imaging Order (CZ) - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Body Height: Imaging Order (CZ)**

## Resource Profile: Body Height: Imaging Order (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/cz-bodyheight | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:CZ_BodyHeight |

 
Profile of body height for the scope of the Czech national interoperability project. 

**Usages:**

* Refer to this Profile: [Composition: Imaging Order (CZ)](StructureDefinition-cz-compositionImageOrder.md) and [Service Request: Imaging Order (CZ)](StructureDefinition-cz-imagingOrderInformation.md)
* Examples for this Profile: [Observation/4a38a57a-fdfe-48df-802c-8d7e8e3e1a3b](Observation-4a38a57a-fdfe-48df-802c-8d7e8e3e1a3b.md) and [Observation/ExampleBodyHeight](Observation-ExampleBodyHeight.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/cz-bodyheight)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-bodyheight.csv), [Excel](StructureDefinition-cz-bodyheight.xlsx), [Schematron](StructureDefinition-cz-bodyheight.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-bodyheight",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bodyheight",
  "version" : "0.1.0-ballot",
  "name" : "CZ_BodyHeight",
  "title" : "Body Height: Imaging Order (CZ)",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Profile of body height for the scope of the Czech national interoperability project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-observationImage",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.code.coding:LOINC",
        "path" : "Observation.code.coding",
        "sliceName" : "LOINC",
        "patternCoding" : {
          "system" : "http://loinc.org",
          "code" : "8302-2"
        }
      },
      {
        "id" : "Observation.code.coding:SNOMEDCT",
        "path" : "Observation.code.coding",
        "sliceName" : "SNOMEDCT"
      },
      {
        "id" : "Observation.code.coding:SNOMEDCT.code",
        "path" : "Observation.code.coding.code",
        "fixedCode" : "1153637007"
      },
      {
        "id" : "Observation.code.coding:NCLP",
        "path" : "Observation.code.coding",
        "sliceName" : "NCLP",
        "patternCoding" : {
          "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
          "code" : "20411"
        }
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.value[x]:valueQuantity",
        "path" : "Observation.value[x]",
        "sliceName" : "valueQuantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valueQuantity.code",
        "path" : "Observation.value[x].code",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/img-order/ValueSet/cz-observationUnitsHeight-vs"
        }
      }
    ]
  }
}

```
