# A.2.6 - Specimen Information - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.6 - Specimen Information**

## Logical Model: A.2.6 - Specimen Information 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/SpecimenInformationCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnSpecimenInformationCz |

 
Information about specimen 

**Usages:**

* Use this Logical Model: [A.2 and A.3 - Body Imaging Order](StructureDefinition-BodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/SpecimenInformationCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SpecimenInformationCz.csv), [Excel](StructureDefinition-SpecimenInformationCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SpecimenInformationCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/SpecimenInformationCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnSpecimenInformationCz",
  "title" : "A.2.6 - Specimen Information",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Information about specimen",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/SpecimenInformationCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "SpecimenInformationCz",
        "path" : "SpecimenInformationCz",
        "short" : "A.2.6 - Specimen Information",
        "definition" : "Information about specimen"
      },
      {
        "id" : "SpecimenInformationCz.identifier",
        "path" : "SpecimenInformationCz.identifier",
        "short" : "A.2.6.1 - Sample identifier",
        "definition" : "An identifier of the specimen which is unique within in a defined scope. Example: identifier assigned by Specimening system, identifier assigned by laboratory etc. Multiple identifiers can be used.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.species",
        "path" : "SpecimenInformationCz.species",
        "short" : "A.2.6.2 - Type of species",
        "definition" : "Biologic type of species for laboratory result reports bound to non-human subjects. \n- Preferred system(s): SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.material",
        "path" : "SpecimenInformationCz.material",
        "short" : "A.2.6.3 - Material",
        "definition" : "Specimen material. \n- Preferred system(s): SNOMED CT\n- Preferred system(s): NCLPMAT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.collectionDate",
        "path" : "SpecimenInformationCz.collectionDate",
        "short" : "A.2.6.4 - Date and time of collection or end of collection and time of collection",
        "definition" : "The date and time of collection, or the time of completion of collection and the time of collection of the material.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.transportDate",
        "path" : "SpecimenInformationCz.transportDate",
        "short" : "A.2.6.5 - Date and time of commencement of transport of the sample to the laboratory",
        "definition" : "Date and time of commencement of transport of the sample to the laboratory",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.type",
        "path" : "SpecimenInformationCz.type",
        "short" : "A.2.6.6 - Sample type",
        "definition" : "Entities collected for examination.\n- Preferred system(s): SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.anatomicLocation",
        "path" : "SpecimenInformationCz.anatomicLocation",
        "short" : "A.2.6.7 - Anatomic location",
        "definition" : "Anatomic location (body location, laterality) where the material is collected, e.g. Elbow, left \n- Preferred system(s): SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.morphology",
        "path" : "SpecimenInformationCz.morphology",
        "short" : "A.2.6.8 - Morphology",
        "definition" : "Morphological abnormalities of the anatomical location where the material is taken, for example wound, ulcer. \n- Preferred system(s): SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.instrument",
        "path" : "SpecimenInformationCz.instrument",
        "short" : "A.2.6.9 - Instrument",
        "definition" : "Device, instrument, physical object (drain, electrode, catheter, etc.).\n- Preferred system(s): SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.procedure",
        "path" : "SpecimenInformationCz.procedure",
        "short" : "A.2.6.10 - Collection procedure",
        "definition" : "Sampling procedure - for cases where it is relevant to the results.\n- Preferred system(s): SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.sourceDevice",
        "path" : "SpecimenInformationCz.sourceDevice",
        "short" : "A.2.6.11 - Source Device",
        "definition" : "If the material is not collected directly from the patient but comes from a patient-related object, e.g. a catheter\n - Preferred system(s): SNOMED CT\n - Preferred system(s): EMDN",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.samplingPoint",
        "path" : "SpecimenInformationCz.samplingPoint",
        "short" : "A.2.6.12 - Sampling point",
        "definition" : "The area where the material was collected; refers to the environment, not the patient.\n - Preferred system(s): SNOMED CT (environment)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.note",
        "path" : "SpecimenInformationCz.note",
        "short" : "A.2.6.13 - Note",
        "definition" : "Note on the material in free text",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.container",
        "path" : "SpecimenInformationCz.container",
        "short" : "A.2.6.14 - Container",
        "definition" : "A.2.6.14 - Container",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.container.type",
        "path" : "SpecimenInformationCz.container.type",
        "short" : "A.2.6.14.1 - Type",
        "definition" : "Type of sampling container - tube, sampling bag, etc. including chemical additives.\n - Preferred system(s): SNOMED CT\n - Preferred system(s): NCLPONP",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.container.specimenQuantity",
        "path" : "SpecimenInformationCz.container.specimenQuantity",
        "short" : "A.2.6.14.2 - Specimen Quantity",
        "definition" : "Quantity of specimen within container",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.container.deviceId",
        "path" : "SpecimenInformationCz.container.deviceId",
        "short" : "A.2.6.14.3 - Device Id",
        "definition" : "Unique machine-readable container identifier.\n - Preferred system(s): UDI",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.container.label",
        "path" : "SpecimenInformationCz.container.label",
        "short" : "A.2.6.14.4 - Label",
        "definition" : "Human readable container identifier.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.additionalData",
        "path" : "SpecimenInformationCz.additionalData",
        "short" : "A.2.6.15 - Additional formalised sample data",
        "definition" : "A.2.6.15 - Additional formalised sample data",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.additionalData.date",
        "path" : "SpecimenInformationCz.additionalData.date",
        "short" : "A.2.6.15.1 - Date",
        "definition" : "Date of discovery of the data, to be indicated if different from the date of the order.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.additionalData.code",
        "path" : "SpecimenInformationCz.additionalData.code",
        "short" : "A.2.6.15.2 - Code",
        "definition" : "Observation code identifying the significance of the data (collection time interval, volume of material collected; density; condition of material, type of collection, etc.)\n - Preferred system(s): NČLPPOL (valueset https://www.dastacr.cz/dasta/hypertext/_TRIDAK_202503012241ISLOD.htm)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.additionalData.value",
        "path" : "SpecimenInformationCz.additionalData.value",
        "short" : "A.2.6.15.3 - Data value",
        "definition" : "Data value including unit of measurement.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.collector",
        "path" : "SpecimenInformationCz.collector",
        "short" : "A.2.6.16 - Collector",
        "definition" : "A.2.6.16 - Collector",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.collector.identifier",
        "path" : "SpecimenInformationCz.collector.identifier",
        "short" : "A.2.6.16.1 - Identifier of the sample collector",
        "definition" : "Identifier of the sample collector – this refers either to an internal identifier assigned by the healthcare provider or (preferably) a national ID of the healthcare professional, such as a license or registration number. If the sample is not collected by a healthcare professional but, for example, by the patient themselves, an appropriate personal identifier should be used instead.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.collector.name",
        "path" : "SpecimenInformationCz.collector.name",
        "short" : "A.2.6.16.2 - Name of the sample collector",
        "definition" : "Name of the sample collector",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.collector.contact",
        "path" : "SpecimenInformationCz.collector.contact",
        "short" : "A.2.6.16.3 - Contact information of the sample collector",
        "definition" : "Contact information of the sample collector (address and telecommunication data).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "SpecimenInformationCz.collector.organization",
        "path" : "SpecimenInformationCz.collector.organization",
        "short" : "A.2.6.16.4 - Organization of the sample collector",
        "definition" : "Organization of the sample collector (healthcare provider).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
