# A.1.6 - Requested Performer (processing person) - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.6 - Requested Performer (processing person)**

## Logical Model: A.1.6 - Requested Performer (processing person) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/RequestedPerformerCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnRequestedPerformerOrderCz |

 
Person who is requested to process document. 

**Usages:**

* Use this Logical Model: [A.1 - Imaging Order header data element](StructureDefinition-HeaderImagingOrder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/RequestedPerformerCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-RequestedPerformerCz.csv), [Excel](StructureDefinition-RequestedPerformerCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "RequestedPerformerCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/RequestedPerformerCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnRequestedPerformerOrderCz",
  "title" : "A.1.6 - Requested Performer (processing person)",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Person who is requested to process document.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/RequestedPerformerCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "RequestedPerformerCz",
        "path" : "RequestedPerformerCz",
        "short" : "A.1.6 - Requested Performer (processing person)",
        "definition" : "Person who is requested to process document."
      },
      {
        "id" : "RequestedPerformerCz.identifier",
        "path" : "RequestedPerformerCz.identifier",
        "short" : "A.1.6.1 -Requested Performer identifier",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "RequestedPerformerCz.name",
        "path" : "RequestedPerformerCz.name",
        "short" : "A.1.6.2 - Requested Performer name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "RequestedPerformerCz.organizationID",
        "path" : "RequestedPerformerCz.organizationID",
        "short" : "A.1.6.3 - Requested Performer organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "RequestedPerformerCz.organization",
        "path" : "RequestedPerformerCz.organization",
        "short" : "A.1.6.4 - Requested Performer organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
