# A.3.3 - Planned Care Orders - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.3 - Planned Care Orders**

## Logical Model: A.3.3 - Planned Care Orders 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/PlannedCareOrdersCz | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:LogEnPlannedCareOrdersCz |

 
Planned Care Orders - Links to planned care orders related to this request form 

**Usages:**

* Use this Logical Model: [A.2 and A.3 - Body Imaging Order](StructureDefinition-BodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/PlannedCareOrdersCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PlannedCareOrdersCz.csv), [Excel](StructureDefinition-PlannedCareOrdersCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PlannedCareOrdersCz",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/PlannedCareOrdersCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnPlannedCareOrdersCz",
  "title" : "A.3.3 - Planned Care Orders",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Planned Care Orders - Links to planned care orders related to this request form",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/PlannedCareOrdersCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "PlannedCareOrdersCz",
        "path" : "PlannedCareOrdersCz",
        "short" : "A.3.3 - Planned Care Orders",
        "definition" : "Planned Care Orders - Links to planned care orders related to this request form"
      },
      {
        "id" : "PlannedCareOrdersCz.identifier",
        "path" : "PlannedCareOrdersCz.identifier",
        "short" : "A.3.3.1 - Planned care order identifier",
        "definition" : "Planned care order identifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "PlannedCareOrdersCz.name",
        "path" : "PlannedCareOrdersCz.name",
        "short" : "A.3.3.2 - Name",
        "definition" : "Name of planned care order for display in the list of appointments",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
