# A.1.3 - Health insurance and payment information - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.3 - Health insurance and payment information**

## Logical Model: A.1.3 - Health insurance and payment information 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/PayerCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnPayerOrderCz |

 
Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care. 

**Usages:**

* Use this Logical Model: [A.1 - Imaging Order header data element](StructureDefinition-HeaderImagingOrder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/PayerCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PayerCz.csv), [Excel](StructureDefinition-PayerCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PayerCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/PayerCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnPayerOrderCz",
  "title" : "A.1.3 - Health insurance and payment information",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/PayerCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "PayerCz",
        "path" : "PayerCz",
        "short" : "A.1.3 - Health insurance and payment information",
        "definition" : "Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care."
      },
      {
        "id" : "PayerCz.insuranceCode",
        "path" : "PayerCz.insuranceCode",
        "short" : "A.1.3.1 - Health insurance code",
        "definition" : "Unique health insurance company identification code.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "PayerCz.insuranceName",
        "path" : "PayerCz.insuranceName",
        "short" : "A.1.3.2 - Health insurance name",
        "definition" : "Full, official name of the healthcare insurance provider.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PayerCz.insuranceNumber",
        "path" : "PayerCz.insuranceNumber",
        "short" : "A.1.3.3 - Health insurance number",
        "definition" : "Number or code under which the insured person is registered at the insurance provider.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      }
    ]
  }
}

```
