# A.1.4 - Information about coverage - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.4 - Information about coverage**

## Logical Model: A.1.4 - Information about coverage 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/CoverageOrderCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnCoverageOrderCz |

 
Coverage information - Information about method of coverage, payer identification data and additional information 

**Usages:**

* Use this Logical Model: [A.1 - Imaging Order header data element](StructureDefinition-HeaderImagingOrder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/CoverageOrderCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-CoverageOrderCz.csv), [Excel](StructureDefinition-CoverageOrderCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CoverageOrderCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/CoverageOrderCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnCoverageOrderCz",
  "title" : "A.1.4 - Information about coverage",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Coverage information - Information about method of coverage, payer identification data and additional information",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/CoverageOrderCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "CoverageOrderCz",
        "path" : "CoverageOrderCz",
        "short" : "A.1.4 - Information about coverage",
        "definition" : "Coverage information - Information about method of coverage, payer identification data and additional information"
      },
      {
        "id" : "CoverageOrderCz.method",
        "path" : "CoverageOrderCz.method",
        "short" : "A.1.4.1 - Method of coverage",
        "definition" : "Method of payment for the order (health insurance, paid by the patient, other)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "CoverageOrderCz.informationPayor",
        "path" : "CoverageOrderCz.informationPayor",
        "short" : "A.1.4.2 - Information about payor",
        "definition" : "Payer identification data and additional information regarding reimbursement other than from health insurance. Identification data includes the identifier, name of the organization or name of the payer, address of the payer and telecommunications connection.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "CoverageOrderCz.informationPayor.name",
        "path" : "CoverageOrderCz.informationPayor.name",
        "short" : "A.1.4.2.1 - Payor name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "CoverageOrderCz.informationPayor.organizationID",
        "path" : "CoverageOrderCz.informationPayor.organizationID",
        "short" : "A.1.4.2.2 - Payor organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "CoverageOrderCz.informationPayor.organization",
        "path" : "CoverageOrderCz.informationPayor.organization",
        "short" : "A.1.4.2.3 - Payor organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "CoverageOrderCz.informationPayor.address",
        "path" : "CoverageOrderCz.informationPayor.address",
        "short" : "A.1.4.2.4 - Address",
        "definition" : "Mailing and home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "CoverageOrderCz.informationPayor.country",
        "path" : "CoverageOrderCz.informationPayor.country",
        "short" : "A.1.4.2.5 - Country",
        "definition" : "Country of the intended recipient as part of the address.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "CoverageOrderCz.informationPayor.telecom",
        "path" : "CoverageOrderCz.informationPayor.telecom",
        "short" : "A.1.4.2.6 - Telecom",
        "definition" : "Telecommunication contact information (addresses) associated to a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      }
    ]
  }
}

```
