# A.2.3 - Clinical event (Encounter) - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.3 - Clinical event (Encounter)**

## Logical Model: A.2.3 - Clinical event (Encounter) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/ClinicalEventCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:LogEnClinicalEventCz |

 
Clinical event (Encounter) - Information about the clinical event to which the order relates 

**Usages:**

* Use this Logical Model: [A.2 and A.3 - Body Imaging Order](StructureDefinition-BodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/ClinicalEventCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ClinicalEventCz.csv), [Excel](StructureDefinition-ClinicalEventCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ClinicalEventCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/ClinicalEventCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnClinicalEventCz",
  "title" : "A.2.3 - Clinical event (Encounter)",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Clinical event (Encounter) - Information about the clinical event to which the order relates",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/ClinicalEventCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalEventCz",
        "path" : "ClinicalEventCz",
        "short" : "A.2.3 - Clinical event (Encounter)",
        "definition" : "Clinical event (Encounter) - Information about the clinical event to which the order relates"
      },
      {
        "id" : "ClinicalEventCz.identifier",
        "path" : "ClinicalEventCz.identifier",
        "short" : "A.2.3.1 - Identifier of clinical event",
        "definition" : "A unique, globally unique identifier of the clinical event to which the order relates.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "ClinicalEventCz.type",
        "path" : "ClinicalEventCz.type",
        "short" : "A.2.3.2 - Type of clinical event",
        "definition" : "Type of clinical event according to the type code list. (e.g. hospitalization, outpatient visit, etc.)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ClinicalEventCz.otherInformation",
        "path" : "ClinicalEventCz.otherInformation",
        "short" : "A.2.3.3 - Other Information",
        "definition" : "Type of services provided, period or duration of the clinical event, connection to other clinical events, etc.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
