# A.5 - Attachments - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.5 - Attachments**

## Logical Model: A.5 - Attachments 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/AttachmentsCz | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:LogEnAttachmentsCz |

 
Additional attachments. 

**Usages:**

* Use this Logical Model: [A - Imaging Order](StructureDefinition-ImagingOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/AttachmentsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AttachmentsCz.csv), [Excel](StructureDefinition-AttachmentsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AttachmentsCz",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/AttachmentsCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnAttachmentsCz",
  "title" : "A.5 - Attachments",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Additional attachments.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/AttachmentsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "AttachmentsCz",
        "path" : "AttachmentsCz",
        "short" : "A.5 - Attachments",
        "definition" : "Additional attachments."
      },
      {
        "id" : "AttachmentsCz.contentType",
        "path" : "AttachmentsCz.contentType",
        "short" : "A.5.1 - Type of content",
        "definition" : "Type of content - MIME type is required",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AttachmentsCz.language",
        "path" : "AttachmentsCz.language",
        "short" : "A.5.2 - Language of content",
        "definition" : "Language of content - HL7 valueset of languages is required",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AttachmentsCz.data",
        "path" : "AttachmentsCz.data",
        "short" : "A.5.3 - Data of content",
        "definition" : "Data inline, base64ed",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ]
      },
      {
        "id" : "AttachmentsCz.url",
        "path" : "AttachmentsCz.url",
        "short" : "A.5.4 - URL of content",
        "definition" : "Uri where the data can be found",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "url"
          }
        ]
      },
      {
        "id" : "AttachmentsCz.title",
        "path" : "AttachmentsCz.title",
        "short" : "A.5.5 - Title of content",
        "definition" : "Label to display in place of the data",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "AttachmentsCz.creation",
        "path" : "AttachmentsCz.creation",
        "short" : "A.5.6 - Date of creation",
        "definition" : "Date attachment was first created",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
