# Body height of patient - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Body height of patient**

## Example Observation: Body height of patient

Profile: [Body Height: Imaging Order (CZ)](StructureDefinition-cz-bodyheight.md)

**status**: Final

**category**: Vital Signs

**code**: Body height

**subject**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rcis#2716126452 (use: official, ))](Patient-Mracena.md)

**effective**: 2020-06-01

**performer**: [Practitioner Testovací Jan](Practitioner-practitionerExample.md)

**value**: 165 cm(Details: UCUM codecm = 'cm')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ExampleBodyHeight",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bodyheight"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "8302-2"
      },
      {
        "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
        "code" : "20411"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "1153637007"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/Mracena"
  },
  "effectiveDateTime" : "2020-06-01",
  "performer" : [
    {
      "reference" : "Practitioner/practitionerExample"
    }
  ],
  "valueQuantity" : {
    "value" : 165,
    "unit" : "cm",
    "system" : "http://unitsofmeasure.org",
    "code" : "cm"
  }
}

```
