# cz-encounter-example - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **cz-encounter-example**

## Example Encounter: cz-encounter-example

Profile: [Encounter (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-encounter.html)

**identifier**: `http://example.org/hospital`/ku-123456789

**status**: In Progress

**class**: [ActCode: AMB](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB) (ambulatory)

**type**: Rentgen pacienta Králíka

**serviceProvider**: [Organization Fakultní nemocnice Obláčkov](Bundle-BundleKralikRTG.md#urn-uuid-5bdedd9b-27c5-4593-ae3a-968c5f25d253)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "db16a37b-d393-4767-bb2e-739f9bff16f9",
  "meta" : {
    "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-encounter"]
  },
  "identifier" : [
    {
      "system" : "http://example.org/hospital",
      "value" : "ku-123456789"
    }
  ],
  "status" : "in-progress",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB"
  },
  "type" : [
    {
      "text" : "Rentgen pacienta Králíka"
    }
  ],
  "serviceProvider" : {
    "reference" : "urn:uuid:5bdedd9b-27c5-4593-ae3a-968c5f25d253"
  }
}

```
